package zyx.mega.movement.melee;

/*
import static zyx.mega.utils.RoboUtils.*;
import static zyx.mega.utils.Config.*;
import static zyx.mega.utils.TurnHandler.*;
import static zyx.mega.utils.Range.*;
import static zyx.mega.geometry.Geometry.*;
import static java.lang.Math.*;
import static java.lang.Double.*;
import static robocode.util.Utils.*;
import static zyx.mega.bot.Enemy.*;
import static zyx.mega.bot.Bot.*;
*/

import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.abs;
import static java.lang.Math.ceil;
import static java.lang.Math.cos;
import static zyx.mega.bot.Enemy.*;
import static java.lang.Math.max;
import static java.lang.Math.min;
import static java.lang.Math.random;
import static zyx.mega.bot.Bot.field_;
import static zyx.mega.bot.Enemy.Phonebook;
import static zyx.mega.utils.TurnHandler.*;
import static zyx.mega.utils.TurnHandler.robot_;
import static zyx.mega.utils.TurnHandler.time_;

import java.awt.Color;
import static java.util.Arrays.*;

import zyx.debug.painter.Painter;
import zyx.mega.bot.Enemy;
import zyx.mega.bot.MeleeEnemy;
import zyx.mega.geometry.Point;
import zyx.mega.utils.Config;


public class MinimumRisk {
  
  private static final int POINTS_TO_TRY = 100;
  private static final double GROWTH_RATE = 5e-2;
  private static final double RADIUS = 240;
  private static final double HALF_RAIDUS = RADIUS / 2;

  public Point target_;
  private double risk_multiplier_;

  private Point positions_[] = new Point[7];
  private double positions_weight_[] = new double[positions_.length];
  private int position_index_;

  public MinimumRisk() {
    for ( int i = 0; i < positions_.length; ++i ) positions_[i] = new Point();
  }
  public void Init() {
    target_ = null;
    fill(positions_weight_, 0);
  }
  
  public void run() {
    if ( target_ != null && me_.distance(target_) < 20 ) target_ = null;
    /*
    Enemy enemies[] = new Enemy[min(robot_.getOthers(), Phonebook().size())];
    double enemy_weight[] = new double[enemies.length];
    double enemy_min_distance[] = new double[enemies.length];
    double min_distance = POSITIVE_INFINITY;
    Enemy closest = null;
    for ( int i = 0, j = 0; i < enemies.length; ++j ) if ( !Phonebook().get(j).dead_ ) {
      Enemy enemy = enemies[i] = Phonebook().get(j);
      enemy_weight[i] =
        /* energy ratio * / (max(1, min(2, 1.3 * enemy.energy_ / me_.energy_)) - 0.3)
        *
        /* current target * / (max(1, 0.5 + 1.5 / ceil(max(1, time_ - enemy.last_hit_time_) / (10 + 2 * enemy.last_hit_power_))));
      enemy_min_distance[i] = enemy.distanceSq(me_);
      if ( enemy_min_distance[i] < min_distance ) {
        min_distance = enemy_min_distance[i];
        closest = enemy;
      }
      for ( int k = 0; k < i; ++k ) {
        double d = enemy.distanceSq(enemies[k]);
        enemy_min_distance[i] = min(enemy_min_distance[i], d);
        enemy_min_distance[k] = min(enemy_min_distance[k], d);
      }
      ++i;
    }
  */
    if ( time_ % 2 == 0 ) {
      positions_[position_index_ = (position_index_ + 1) % positions_.length].setLocation(robot_.getX(), robot_.getY());
      positions_weight_[position_index_] = random() * 1000 + 300;
      positions_[position_index_].x_ += random() * 10 - 5;
      positions_[position_index_].y_ += random() * 10 - 5;
    }
    if ( time_ >= 30 && time_ < 37 ) {
      robot_.setAhead(0);
      return;
    }
    double best_risk = target_ == null ? POSITIVE_INFINITY : (RiskFactor(target_) * risk_multiplier_);
    risk_multiplier_ += GROWTH_RATE;
    for ( int i = 0; i < POINTS_TO_TRY; ++i ) {
      double r = random() * HALF_RAIDUS + HALF_RAIDUS;
      double x = random() * 2 - 1;
      double y = random() * 2 - 1;
      Point point = new Point(me_.x_ + x * r, me_.y_ + y * r);
      //if ( Config.DEBUG ) Painter.Add(point, 3, Color.WHITE);
      double risk = RiskFactor(point);
      if ( risk < best_risk ) {
        best_risk = risk;
        target_ = point;
        risk_multiplier_ = 0.7;
      }
    }
    if ( Config.DEBUG ) for ( int i = 0; i < positions_.length; ++i ) Painter.Add(positions_[i], 3, Color.RED);
    if ( Config.DEBUG ) Painter.Add(target_, 5, Color.BLUE);
    Move(me_.distance(target_), me_.Angle(target_), true);
  }
  private double RiskFactor(Point point) {
    if ( !field_.Inside(point, false) ) return POSITIVE_INFINITY;
    double risk = 0;
    int limit = min(others_, Phonebook().size());
    for ( int e = 0; e < limit; ++e ) {
      MeleeEnemy menemy = alive_enemies_[e];
      Enemy enemy = menemy.bot_;
      //System.out.println(me_ + "  " + point + "  " + enemy);
      double perpendicularity = abs(cos(me_.Angle(point) - enemy.bearing_));
      if ( others_ < 3 ) {
        perpendicularity *= 2;
      } else if ( others_ < 4 ) {
        perpendicularity *= (enemy == closest_ ? 1.1 : 1);
      } else {
        perpendicularity *= (enemy == closest_ ? 2 : 1.2);
      }
      double anti_gravity = menemy.min_distance_ / point.distanceSq(enemy);
      risk += menemy.weight_ * perpendicularity * anti_gravity * (random() * 0.2 + 0.8);
    }
    /**/
    for ( int i = 0; i < positions_.length; ++i ) {
      int j = (i + position_index_) % positions_.length;
      double anti_gravity = positions_weight_[j] / max(1e-5, point.distanceSq(positions_[j]));
      risk += anti_gravity;
    }
    /**/
    if ( point.x_ < 38 || point.x_ >= field_.width_ - 2 ) risk *= 1.5;
    if ( point.y_ < 38 || point.y_ >= field_.height_ - 2 ) risk *= 1.5;
    return risk;
  }
}
