package yk;
import robocode.*;
import java.util.Vector;
import java.awt.Color;

/**
 * JahRoslav - a robot by (Yaroslav Kourovtsev)
 */
public class JahRoslav extends AdvancedRobot
{
	private class C
	{
		public double targetheading;//radians
		public double x;
		public double y;
		public double velocity;
		public long time;
		public double distance;
	}
	/**
	 * run: JahRoslav's default behavior
	 */
	private boolean tracking = false;
	private boolean left = false;
	private double bullet_velocity = 17;
	private boolean targetVisible = false;
	private Vector targets = new Vector();
	private boolean forward = true;
	private void correctDirection()
	{
		double x = getX();
		double y = getY();
		double w = getBattleFieldWidth();
		double h = getBattleFieldHeight();
		double r = getHeadingRadians();
		double dx = Math.sin(r);
		double dy = Math.cos(r);
		if (!forward)
		{
			dx = -dx;
			dy = -dy;
		}
		if ((x < 100 && dx < 0)
			|| (x > w - 100 && dx > 0)
			|| (y < 100 && dy < 0)
			|| (y > h - 100 && dy > 0))
			reverseDirection();
	}
	private void reverseDirection()
	{
		if (forward)
		{
			setBack(40000);
			forward = false;
		}
		else
		{
			setAhead(40000);
			forward = true;
		}
	}
	public void run() {
		setColors(Color.pink,Color.yellow,Color.gray);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		Bullet b = fireBullet(0.1);
		if (b != null)
			bullet_velocity = b.getVelocity();
		setTurnRadarRight(360);
		addCustomEvent(new RadarTurnCompleteCondition(this));
		while(true) {
			setAhead(40000);
			setTurnRight(90);
			
		   execute();
		   while (getTurnRemaining() != 0) {
		     execute();
			correctDirection();
		   }
			

			for (double turn = -180; turn <= 180; turn += 360)
			{			
				setTurnRight(turn);
				execute();
			 	while (getTurnRemaining() != 0) {
					execute();
					correctDirection();
				}
			}
		}
	}
	
	public void onCustomEvent(CustomEvent e)
	{
		setTurnRadarRight(360);
		ProcessTargets();
	}
	
	private void ProcessTargets()
	{
			C closest = null;
			double dist = 10000;
			for(int i = 0; i < targets.size(); i++)
			{
				C c = (C)targets.elementAt(i);
				if (c.distance < dist)
				{
					closest = c;
					dist = c.distance;
				}
			}
			if (closest != null)
			{
				onScannedRobot1(closest);
				targets.clear();
			}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		C c = new C();
		c.distance = e.getDistance();
		c.velocity = e.getVelocity();
		c.targetheading = e.getHeadingRadians();
		c.time = e.getTime();
		double targetAngle = e.getBearingRadians() + getHeadingRadians(); // direction to target (absolute)
		c.x = getX() + c.distance * Math.sin(targetAngle);
		c.y = getY() + c.distance * Math.cos(targetAngle);
		targets.add(c);
		scan();
	}
	public void onScannedRobot1(C c) {
		if (getEnergy() < 10)
			return;
			
		double myheading = getHeadingRadians();
		// add velocity * time
		long time = getTime();
		c.x += Math.sin(c.targetheading) * c.velocity * (time - c.time);
		c.y += Math.cos(c.targetheading) * c.velocity * (time - c.time);
		
		
		double dX = c.x - getX();
		double dY = c.y - getY();
		double targetAngle = Math.PI / 2;
		if (dY != 0)
			targetAngle = Math.atan(Math.abs(dX)/Math.abs(dY));
		if (dY < 0)
		{
			if (dX < 0)
				targetAngle = Math.PI + targetAngle;
			else
				targetAngle = Math.PI - targetAngle; // direction to target position at the moment of scan
		}
		else if (dX < 0) // dY > 0
		{
			targetAngle = -targetAngle;
		}
		
		
		if (targetAngle > Math.PI)
			targetAngle -= 2 * Math.PI;
		else if (targetAngle < -Math.PI)
			targetAngle += 2 * Math.PI;
					
		double beta_angle = c.targetheading - targetAngle;
		double angle_corr = c.velocity / bullet_velocity * Math.sin(beta_angle);
			
		setGunHeadingRadians(targetAngle + angle_corr);
		Bullet b = null;
		if (c.distance < 300)
			b = fireBullet(3);
		else if (c.distance < 700)
			b = fireBullet(1);
		if (b != null)
		{
			bullet_velocity = b.getVelocity();
		}
	}

	private void setGunHeadingRadians(double heading)
	{
		setGunHeading(heading * 180 / Math.PI);
	}
		
	private void setGunHeading(double heading)
	{
		while (heading >= 360)
			heading -= 360;
		while (heading < 0)
			heading += 360;
		double current = getGunHeading();
		if (heading == current)
			return;
		double diff = heading - current;
		if (diff > 180)
			diff -= 360;
		if (diff < -180)
			diff += 360;
		if (diff == 0 || diff == 360)
			return;
		if (diff > 0)
		{
			turnGunRight(diff);
			left = false;
		}
		else
		{
			turnGunLeft(-diff);
			left = true;
		}
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	}
	
	public void onWin(WinEvent e) {
		for (int i = 0; i < 15; i++)
		{
			turnLeft(40);
			turnRight(40);
		}
	}
	public void onHitRobot(HitRobotEvent e)
	{
		double botheading = e.getBearing() + getHeading();
		double bot_radians = e.getBearingRadians() + getHeading() / 180 * Math.PI;
		if (botheading >= 360)
			botheading -= 360;
		else if (botheading <= -360)
			botheading += 360;
		
		setGunHeadingRadians(bot_radians);
		Bullet b = fireBullet(3);
		if (b != null)
		{
			bullet_velocity = b.getVelocity();
		}
		
		reverseDirection();	
	}
	public void onHitWall(HitWallEvent e)
	{
		reverseDirection();
	}
}
