package dam;

import dam.targetting.*;

import dam.movement.*;
import dam.util.*;


public class EnemyBullet
{
	
	TargettingStrategy ts;
	double firepower;
	BasicTarget target;
	long launchedTime;
	
	
	public EnemyBullet(BasicTarget me, double firepower)
	{
		ts = new CircularTargettingSimple();
		ts.setTarget(me);
		this.firepower = firepower;
		target = me;
	}
	
	public GridPoint getPosition(long when)
	{
		ts.guess(when);
		GridPoint p = new GridPoint(ts.getX(), ts.getY(), -50);
		return p;
	}
	
	public GridPoint getFinalPosition()
	{
		long time = (int) Math.round(target.getDistance() / (20 - (3 * firepower)));
		time += target.getLastScanTime();
		return getPosition(time);
	}
	
	public long getTime(){ return target.getLastScanTime(); }
	
	public double getOriginalDistance(){ return target.getDistance(); }
}