package axeBots.pilot.waves;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import robocode.Bullet;
import robocode.Condition;
import robocode.HitByBulletEvent;
import axeBots.AxeBot;
import axeBots.SilverSurfer;
import axeBots.data.SegmentedGFs;
import axeBots.pilot.WaveSurferPilot;
import axeBots.pilot.navigator.Course;
import axeBots.pilot.navigator.WaveNavigator;
import axeBots.silversurfer.AxeTarget;
import axeBots.silversurfer.AxeVector;
import axeBots.util.RoboMath;
// This Class is originally based on PEZ's code published on the page:
// http://robowiki.dyndns.org/perl/robowiki?EnemyWave
// All credits to PEZ. Thanks, PEZ!
// This code is released under the RoboWiki Public Code Licence (RWPCL),
// datailed on:
// http://robowiki.dyndns.org/?RWPCL
//
// $Id: EnemyWave.java,v 1.14 2004/10/17 21:57:17 Marcos Exp $
public class EnemyWave extends Condition {
	private boolean hit;
	private double bulletPower;
	private double bulletVel;
	private double fireTime;
	private double myAttackAngle;
	private Point2D.Double center;
	private Point2D.Double myOriginalPos;
	private AxeTarget him;
	private boolean passMiddle = false;
	private boolean remove = false;
	private boolean done = false;
	private int countdown = 4;
	private boolean dangerZone = false;
	private static double lowerPowerBullTillNow = 3D;
	private static double lowestPowActiveBull = Double.NaN;
	private static double highestPowActiveBull = Double.NaN;
	private double distToMe = 0;
	private int dir = -1; //normal, re= 1;
	private int velocity;
	private int acceleration;
	private static ArrayList radar = new ArrayList();

	private static final int TIME_FASE = 1;//2;
	//private static ArrayList lastGFs=new ArrayList();
	//    private static VisitRecord visits = new VisitRecord();
	private Color hiliteCl = new Color(0, 255, 255);
	private Color normalCl = new Color(0, 64, 64);
	private Color hitCl = new Color(255, 0, 0);
	private Color bulHitBullCl = new Color(255, 255, 255);
	private boolean hitBull;
	private static int activeWavesCount;
	private boolean referenceWave = false;
	private int distToWall;
	private int lastArrivalEstimatedDelta = 0;
	private double weight;
	private double[] resultGraph;
	private static EnemyWave newestWave = null;
	private boolean passed;
	private long surfingSince;

	public EnemyWave(double bulletPower, double fireTime, AxeTarget him) {

		fireTime -= TIME_FASE;
		this.him = him;
		this.fireTime = fireTime;
		this.bulletPower = bulletPower;
		this.bulletVel = RoboMath.getBulletVelocity(this.bulletPower);
		//ao atirar ele andou +1...

		this.center = him.getPos((int) this.fireTime /* + 1 */);
		this.myOriginalPos = AxeBot.getIt().getPos((int) this.fireTime);
		//System.out.println(""+him.);
		this.velocity = AxeBot.getIt().getVelocity((int) fireTime);

		//		ALTERADO: NOVO GET DIRECTION!
		this.dir = /*
				    * ((him.getBotData().getMyAttackAngle((int)
				    * fireTime)*velocity)>0)?1:-1;
				    */AxeBot
				.getIt().getDirection((int) fireTime);

		this.acceleration = AxeBot.getIt().getAcceleration((int) fireTime);
		this.distToWall = RoboMath.getDistanceToWall(myOriginalPos);
		this.myAttackAngle = him.getBotData().getMyAttackAngle((int) fireTime);

		if (this.bulletPower < lowerPowerBullTillNow) {
			lowerPowerBullTillNow = this.bulletPower;
		}
		//		System.out.println(">>>> New Wave at:"+fireTime+" ele:"+center+"
		// eu:"+myOriginalPos+" v:"+velocity+" p:"+AxeBot.getIt().pos() );
		AxeBot.getIt().addCustomEvent(this);
		radar.add(this);
		distToMe = center.distance(myOriginalPos);
		EnemyWave surfed = WaveNavigator.getWave();
		if (Course.MULTI_WAVE_SURFING) {
			if (surfed != null) {
				Point2D.Double myPos = AxeBot.getIt().pos();
				int arrivalSurfed = (int) EnemyWave.bulletTime(myPos, surfed);
				int arrivalThis = (int) EnemyWave.bulletTime(myPos, this);
				//			alterado: NOVO WEIGHTENING PARA MULTI WAVES
				if (arrivalThis - arrivalSurfed <= /* 10){//NOVO: */7) {
					WaveNavigator.setRecalculate(true);
				}
			}
		}
		newestWave = this;
	}
	public boolean isActive() {
		return (!remove);
	}
	private boolean powerIsEqual(double power) {
		return Math.abs(power - bulletPower) < 0.1;
		//		(int)Math.round(power * 1000)
		//            == (int)Math.round(bulletPower * 1000);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see robocode.Condition#test()
	 */
	public boolean test() {
		//		if (triggerTest(0)) {
		//			System.out.println("==> wave:"+this+" GF:"+this.getGF() );
		//				}
		Point2D.Double myPos = AxeBot.getIt().pos();
		distToMe = center.distance(myPos);

		if (remove && (countdown-- == 0)) {
			AxeBot.getIt().removeCustomEvent(this);
			if (!radar.remove(this)) {
				System.out.println("************* NAO REMOVEU DO RADAR!!!");
			} else {
				//      System.out.println("* removing:" + this);
			}
			return false;
		} else {
			this.draw();
			//        if (triggerTest(- (0 * this.bulletVel))) {
			//            AxeBot.getIt().getMyPilot().synchro();
			//        }
			if (triggerTest((him.isHeadOn()) ? -bulletVel : -20)) {
				dangerZone = true;
			}
			if (!passMiddle && (triggerTest(0) || hit)) {
				passMiddle = true;
				//if(!him.isHeadOn() ){
				passed = true;
				//}
				int gf = this.getGF(myPos);
				//ALTERADO: NOVO VISITS ew.getConsecutives(AxeBot.getIt().pos(), AxeBot.BOT_DIM)
				him.getBotData().getGfHistory().updateVisit((int) distToMe, gf,0);
//						getConsecutives(AxeBot.getIt().pos(), AxeBot.BOT_DIM));
			}

			if (!passed && (triggerTest(20) || hit)) {
				passed = true;

			}

			if (!remove && (triggerTest(60) || hit || hitBull)) {
				//        	System.out.println("==> wave:"+this+"
				// triggerTest:"+triggerTest(40)+" hit:"+ hit +" hitBull:"+
				// hitBull);
				remove = true;
			}
			/*
			 * if (triggerTest(him.isHeadOn() ? 0 : -25 - bulletVel)) {
			 * dangerZone = true; if (AxeBot.GL) { ellipse.setColor(hiliteCl); } }
			 * if (!passMiddle && (triggerTest((him.isHeadOn() &&
			 * him.getDistance() > 300) ? 20 : 0) || hit)) { passMiddle = true;
			 * 
			 * int gf = this.getGF(myPos);
			 * him.getBotData().getGfHistory().updateVisit((int) distToMe, gf,
			 * 0);// getConsecutives(myPos, // 25));//this.getConsecutives( //
			 * AxeBot.getIt().pos() ,51 // ));//0); // double mygf =
			 * this.getPreciseGF(myPos);
			 *  // System.out.println("MIDDLE OF THE WAVE:"+gf+" //
			 * precise:"+mygf+" chosen:"+Course.getChosen() +" //
			 * @"+AxeBot.getIt().getTime()); } if (!remove && (triggerTest(40) ||
			 * hit || hitBull)) { // System.out.println("==> wave:"+this+" //
			 * triggerTest:"+triggerTest(40)+" hit:"+ hit +" hitBull:"+ //
			 * hitBull); remove = true; }
			 */
		}
		//		if (radar.isEmpty()) {
		lowestPowActiveBull = Double.NaN;
		highestPowActiveBull = Double.NaN;
		//		}
		activeWavesCount = radar.size();
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave w = (EnemyWave) radar.get(i);
			if (Double.isNaN(lowestPowActiveBull)
					|| w.bulletPower < lowestPowActiveBull) {
				lowestPowActiveBull = w.bulletPower;
			}
			if (Double.isNaN(highestPowActiveBull)
					|| w.bulletPower < highestPowActiveBull) {
				highestPowActiveBull = w.bulletPower;
			}
		}
		return false;
	}

	public static void excludeDangerZoneBullets() {
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			ew.done = ew.dangerZone;
		}

	}

	public static void markWaveAsDone(EnemyWave wav) {
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			if (ew == wav) {
				ew.done = true;
				return;
			}
		}

	}

	public int getConsecutives(Point2D.Double mypos, double sz) {
		double arc = getArcLen(mypos);
		//tamanho da fatia de cada gf
		double slc = arc / (SegmentedGFs.GF_QT - 1);
		return (int) Math.round((sz / 2) / slc);
	}
	public static void clear() {
		radar = new ArrayList();
	}
	public static EnemyWave getWave(double pw, Point2D.Double pt) {
		EnemyWave ret = null;
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			if ((ew.isActive())
					&& (ew.powerIsEqual(pw))
					&& ((ret == null) || bulletDist(pt, ew) < bulletDist(pt,
							ret))) {
				ret = ew;
			}
		}
		return ret;
	}
	public static EnemyWave getLastWave() {
		return (radar.isEmpty()) ? null : (EnemyWave) radar
				.get(radar.size() - 1);
	}
	public boolean incoming(boolean checkDangerZone) {

		return this.isActive() && !this.done
				&& !(checkDangerZone && this.dangerZone) && !this.isPassed();
	}
	public static EnemyWave getCurrentWave(Point2D.Double pt,
			boolean excludeDangerZone) {
		EnemyWave ret = null;
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			if (ew.isActive() && !ew.done
					&& !(excludeDangerZone && ew.dangerZone) && !ew.isPassed()) {
				ret = compareWaves(ew, ret, pt);
			}
		}
		//System.out.println("getCurrentWave:" + ret);
		return ret;
	}
	private static EnemyWave compareWaves(EnemyWave newWav, EnemyWave oldWav,
			Point2D.Double pt) {
		if (oldWav == null) {
			return newWav;
		}
		double btNew = bulletTime(pt, newWav);
		double btOld = bulletTime(pt, oldWav);

		//ALTERADO: ALL WAVES SURFING SURFA A INCOMING.

		return (btNew < btOld) ? newWav : oldWav;

		//		return ((newWav.bulletPower > oldWav.bulletPower) && (btNew - 2 <
		// btOld))
		//				|| ((newWav.bulletPower < oldWav.bulletPower) && (btNew + 2 < btOld))
		//				? newWav
		//				: oldWav;

	}

	public static void fillInGraph(EnemyWave w) {
		AxeTarget him = AxeBot.getIt().getMyTarget();
		SegmentedGFs gfHist = him.getBotData().getGfHistory();

		double[] allHitsGraph = SegmentedGFs.getAllHits();
		//ALTERADO: NOVO FAST LEARNING...
		double[] hitsGraph = gfHist.getNotEmptyHits(w);
		int qtd = (hitsGraph==null)?0:3;//(int) gfHist.getQtdHits(w);
		double[] visitsGraph = /*
							    * (him.getBotData().getGfHistory().isHeadOn()
							    * )?null:
							    */gfHist
				.getVisits(w);
		//		ALTERADO: APRENDIZADO RAPIDO
		w.resultGraph = gfHist.rateGFs(allHitsGraph, hitsGraph, qtd,
				visitsGraph,/* gfHist.getDistHits(w),gfHist.getVelHits(w),gfHist.getAccHits(w), */
				him.isHeadOn());

	}

	public static ArrayList getWavesWeightened() {
		SilverSurfer me = AxeBot.getIt();
		Point2D.Double myPos = me.pos();
		EnemyWave surfed = WaveNavigator.getWave();

		ArrayList waves = new ArrayList();
		//		ALTERADO: INCLUI FPW NO WEIGHTENING...
		surfed.weight = 1D * ((surfed.bulletPower > 1.5) ? 1.5D : 1D);//((surfed.bulletPower>2)?2D:(surfed.bulletPower>1)?1D:(surfed.bulletPower>0.5)?0.5D:0.25D);
		EnemyWave.fillInGraph(surfed);
		double arriveSurfed = EnemyWave.bulletTime(myPos, surfed);
		//waves.add(surfed);

		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			if (ew == surfed) {
				continue;
			}
			if (ew.isActive() && !ew.done && ew.getDistance(myPos) > 20) {
				double arrive = EnemyWave.bulletTime(myPos, ew)
						- (arriveSurfed);
				//ALTERADO: NOVO WEIGHTENING PARA MULTI WAVES
				double w = /*
						    * old:(1 - ((1D / 30D) * Math.pow(arrive
						    * ,1.5)));//novo:
						    */(1 - ((1D / 55D) * Math
						.pow(arrive, 2)));
				//ALTERADO: INCLUI FPW NO WEIGHTENING...
				ew.weight = RoboMath.boundIt(w, 0, 1)
						* ((surfed.bulletPower > 1.5) ? 1.5D : 1D);//((ew.bulletPower>2)?2D:(ew.bulletPower>1)?1D:(ew.bulletPower>0.5)?0.5D:0.25D);
				if (ew.weight > 0) {
					waves.add(ew);
					EnemyWave.fillInGraph(ew);
				}
			}
		}
		return waves;
	}

	public static void estimateArrivalDeltas() {
		SilverSurfer me = AxeBot.getIt();
		Point2D.Double myPos = me.pos();
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			ew.lastArrivalEstimatedDelta = (int) (EnemyWave.bulletTime(myPos,
					ew));
		}
	}

	//desesperado
	public static EnemyWave getCurrentWave(Point2D.Double pt) {
		EnemyWave ret = null;
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			if (ew.isActive()) {
				ret = compareWaves(ew, ret, pt);
			}
		}
		//System.out.println("getCurrentWave:" + ret);
		return ret;
	}
	public static ArrayList getAllActiveWaves() {
		ArrayList ret = new ArrayList();
		for (int i = 0; i < radar.size(); i++) {
			EnemyWave ew = (EnemyWave) radar.get(i);
			if (ew.isActive() && !ew.isPassed() && !ew.done) {
				ret.add(ew);
			}
		}
		return ret;
	}

	public static ArrayList getAllWaves() {

		return radar;
	}
	//	public static int countCurrentWaves() {
	//		int ret = 0;
	//		for (int i = 0; i < radar.size(); i++) {
	//			EnemyWave ew = (EnemyWave) radar.get(i);
	//			if (ew.isActive() && !ew.isPassMiddle()&& !ew.done) {
	//				ret++;
	//			}
	//		}
	//		//System.out.println("getCurrentWave:" + ret);
	//		return ret;
	//	}

	private static double bulletDist(Point2D.Double pt, EnemyWave ew) {
		return Math.abs(pt.distance(ew.center) - ew.bulletTravel());
	}

	public static double bulletTime(Point2D.Double pt, EnemyWave ew) {
		return Math.abs(pt.distance(ew.center) - ew.bulletTravel())
				/ ew.bulletVel;
	}

	//    public static Point2D.Double getCloserWaveCenter() {
	//        return (radar.size() == 0)
	//            ? null
	//            : ((EnemyWave)radar.get(radar.size() - 1)).hisPos;
	//    }
	public int getArcLen(Point2D.Double pos) {
		double ray = pos.distance(center);
		//		double arcAng = SegmentedGFs.getGFArcWdt(this.bulletPower, ray);
		return SegmentedGFs.getArcLen(this.bulletPower, ray);//(int) (ray * 2 *
		// Math.PI *
		// (arcAng /
		// 360D));
	}
	//    //todo o array, comecando dos gfs negativos
	//    public Point2D.Double[] getWaveLinearGFs(int arcLen, Point2D.Double pos)
	// {
	//        Point2D.Double[] gfPts= new Point2D.Double[SegmentedGFs.GF_QT];
	//        double slcLen= arcLen / (double)SegmentedGFs.GF_QT;
	//        double start= -arcLen / 2D;
	//        double end= start + slcLen;
	//
	//        for (int i= 0; i < SegmentedGFs.GF_QT; i++) {
	//            gfPts[i]= new Point2D.Double(start, end);
	//            start += slcLen;
	//            end += slcLen;
	//        }
	//        return gfPts;
	//    }
	public int getWaveLinearGF(double arcLen, double linearPos) {
		double slcLen = arcLen / (double) SegmentedGFs.GF_QT;
		return (int) ((linearPos + (arcLen / 2D)) / slcLen);
	}
	public double getWaveLinearPos(Point2D.Double pos) {
		return (int) ((this.getArcLen(pos) / 2D) * this.getRealGF(pos));
	}
	public Point2D.Double getWaveGfPoint(Point2D.Double myPos, double gf) {
		AxeVector ponteiro = new AxeVector(this.getCenter(), myPos);
		double mod = ponteiro.getModule();
		ponteiro.setEnd(myOriginalPos);
		ponteiro.setModule(mod);
		double arco = SegmentedGFs.getGFArcWdt(this.bulletPower, mod) / 2D;
		double relativeGf = gf - (SegmentedGFs.GF_QT / 2);
		double slice = getDir() * -1 * (arco / ((int) SegmentedGFs.GF_QT / 2))
				* relativeGf;
		//		System.out.println("arco:"+arco+" slice:"+slice+ " gf:"+gf+"
		// relativeGf:"+relativeGf+" dir:"+this.getDir() );
		ponteiro.addTheta(slice);

		return ponteiro.getEndPoint();
	}
	public double gfToLinear(double gf, double arcLen) {
		double slcLen = arcLen / (double) SegmentedGFs.GF_QT;
		return (int) ((gf * slcLen) - (arcLen / 2D) + (slcLen / 2D));
	}
	public int getDangerStartTime(long time, Point2D.Double pos) {
		double dim = 20;
		double d = pos.distance(center) - bulletTravel() - dim;
		return (int) (time + (int) Math.ceil(d / bulletVel));
	}
	public int getDangerEyeTime(long time, Point2D.Double pos) {

		double d = pos.distance(center) - bulletTravel();
		return (int) (time + (int) Math.ceil(d / bulletVel));
	}
	public int getDangerEndTime(long time, Point2D.Double pos) {
		double dim = 20;
		double d = pos.distance(center) - bulletTravel() + dim;
		return (int) (time + (int) Math.ceil(d / bulletVel));
	}
	public void hit() {
		hit = true;
	}
	public void hitBull() {
		hitBull = true;
	}
	public double getOriginalDistance() {
		return center.distance(myOriginalPos);
	}
	public double getDistance(Point2D.Double p, double deltaTime) {
		deltaTime += AxeBot.getIt().getTime();
		deltaTime -= this.fireTime;
		double d = p.distance(center);
		return d -= bulletTravel(deltaTime);
	}

	public double getDistance(Point2D.Double p) {
		double deltaTime = AxeBot.getIt().getTime();
		deltaTime -= this.fireTime;
		double d = p.distance(center);
		return d -= bulletTravel(deltaTime);
	}

	//    public int getGF() {
	//        SilverSurfer me= AxeBot.getIt();
	//
	//        double dist= getDistance();
	//        AxeVector originalAngle= new AxeVector(hisPos, myPos);
	//
	//        AxeVector nowAngle= new AxeVector(hisPos, me.pos());
	//        double angularDelta= originalAngle.getDiffTheta(nowAngle);
	//
	//        angularDelta=
	//            AxeBot.getIt().adjustDirection(
	//                (int)this.fireTime,
	//                him,
	//                angularDelta);
	//
	//        int gf= SegmentedGFs.getGF(this.bulletPower, angularDelta, dist);
	//        //- (int) (SegmentedGFs.GF_QT / 2D);
	//
	//        return gf;
	//    }
	public int getGF(HitByBulletEvent e) {

		return getGF(e.getBullet());
	}
	public int getGF(Bullet b) {
		//        SilverSurfer me= AxeBot.getIt();
		double dist = getOriginalDistance();
		AxeVector originalAngle = new AxeVector(center, myOriginalPos);
		//        AxeVector nowAngle=
		//            new AxeVector(
		//                center,
		//                new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
		AxeVector nowAngle = new AxeVector();
		nowAngle.setOrigin(center);
		nowAngle.setTheta(b.getHeading());
		//        System.out.println("getGF(): head:"+e.getHeading() +"
		// "+e.getBullet().getHeading() );
		double angularDelta = nowAngle.getDiffTheta(originalAngle);
		angularDelta = ((this.dir * angularDelta) < 0) ? -Math
				.abs(angularDelta) : Math.abs(angularDelta);
		int gf = SegmentedGFs.getGF(this.bulletPower, angularDelta, dist);
		//- (int) (SegmentedGFs.GF_QT / 2D);
		return gf;
	}
	public int getGF(Point2D.Double pos) {
		double dist = getOriginalDistance();
		AxeVector originalAngle = new AxeVector(center, myOriginalPos);
		AxeVector nowAngle = new AxeVector(center, new Point2D.Double(pos
				.getX(), pos.getY()));
		double angularDelta = nowAngle.getDiffTheta(originalAngle);
		angularDelta = ((this.dir * angularDelta) < 0) ? -Math
				.abs(angularDelta) : Math.abs(angularDelta);
		int gf = SegmentedGFs.getGF(this.bulletPower, angularDelta, dist);
		//- (int) (SegmentedGFs.GF_QT / 2D);
		return gf;
	}
	public double getMaxEscapeAngle() {
		return Math.toDegrees(Math.asin(8 / this.bulletVel));
	}
	//  gf entre -1 e 1
	public double getPreciseGF(Point2D.Double pos) {
		AxeVector originalAngle = new AxeVector(center, myOriginalPos);
		AxeVector nowAngle = new AxeVector(center, pos);
		double angularDelta = nowAngle.getDiffTheta(originalAngle);
		angularDelta = ((this.dir * angularDelta) < 0) ? -Math
				.abs(angularDelta) : Math.abs(angularDelta);
		double max = getMaxEscapeAngle();
		double slc = max / Math.floor(SegmentedGFs.GF_QT / 2);
		//        System.out.println("angularDelta:"+angularDelta+" max:"+max+"
		// slc:"+slc);
		return (angularDelta / slc) + Math.floor(SegmentedGFs.GF_QT / 2);
	}
	// gf entre -1 e 1
	public double getRealGF(Point2D.Double pos) {
		double dist = getOriginalDistance();
		AxeVector originalAngle = new AxeVector(center, myOriginalPos);
		AxeVector nowAngle = new AxeVector(center, new Point2D.Double(pos
				.getX(), pos.getY()));
		double angularDelta = nowAngle.getDiffTheta(originalAngle);
		angularDelta = //*=this.dir;
		((this.dir * angularDelta) < 0) ? -Math.abs(angularDelta) : Math
				.abs(angularDelta);
		//				AxeBot.getIt().adjustDirection(
		//					(int)this.fireTime,
		//					him,
		//					angularDelta);
		double gf = SegmentedGFs
				.getRealGF(this.bulletPower, angularDelta, dist);
		//- (int) (SegmentedGFs.GF_QT / 2D);
		return gf;
	}
	private boolean triggerTest(double distanceDelta) {
		return bulletTravel() >= center.distance(AxeBot.getIt().pos())
				+ distanceDelta;
	}
	//ALTERADO: BULLET TRAVEL+1
	private double bulletTravel() {
		return bulletVel
				* (double) (AxeBot.getIt().getTime() - fireTime /* +1 */);
	}

	//	ALTERADO: BULLET TRAVEL+1
	private double bulletTravel(double delta) {
		return bulletVel * (delta /* +1D */);
	}

	private void draw() {

	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		SilverSurfer me = AxeBot.getIt();
		Point2D.Double myPos = me.pos();

		return "EnemyWave from " + him.getName() + " bulletPw:"
				+ this.bulletPower + " fired:" + this.fireTime + " arrival:"
				+ EnemyWave.bulletTime(myPos, this) + " lastArrival:"
				+ lastArrivalEstimatedDelta + " active:" + isActive()
				+ " done:" + done + " dist:"
				+ EnemyWave.bulletDist(myPos, this) + " traveled:"
				+ bulletTravel() + " surfingSince:" + surfingSince;
	}
	/**
	 * @return
	 */
	public Point2D.Double getCenter() {
		return center;
	}
	/**
	 * @return
	 */
	public double getBulletVel() {
		return bulletVel;
	}
	/**
	 * @return
	 * 
	 * @author Marcos Machado
	 * @since 18/02/2004
	 * @modified
	 */
	public Point2D.Double getMyOriginalPos() {
		return myOriginalPos;
	}
	/**
	 * @return
	 */
	public int getDir() {
		return dir;
	}
	/**
	 * @return
	 */
	public int getMyGF() {
		return getGF(AxeBot.getIt().pos());
	}
	/**
	 * @return
	 */
	public double getBulletPower() {
		return bulletPower;
	}
	/**
	 * @return
	 */
	public AxeTarget getOwner() {
		return him;
	}
	/**
	 * @return
	 */
	public boolean isDangerZone() {
		return dangerZone;
	}
	//    /**
	//     * @return
	//     */
	//    public static ArrayList getLastGFs(int until) {
	//// return EnemyWave.lastGFs ;
	//    	return visits.getLastGFs( until);
	//    }
	/**
	 * @return Returns the fireTime.
	 */
	public double getFireTime() {
		return fireTime;
	}
	/**
	 * @return Returns the passMiddle.
	 */
	public boolean isPassed() {
		return passed;
	}
	/**
	 * @return Returns the acceleration.
	 */
	public int getAcceleration() {
		return acceleration;
	}
	/**
	 * @return Returns the velocity.
	 */
	public int getVelocity() {
		return velocity;
	}
	public static int getActiveWavesCount() {
		return activeWavesCount;
	}
	public static double getHighestPowActiveBull() {
		return highestPowActiveBull;
	}
	public static double getLowerPowerBullTillNow() {
		return lowerPowerBullTillNow;
	}
	public static double getLowestPowActiveBull() {
		return lowestPowActiveBull;
	}
	/**
	 * @return
	 */

	public boolean isReferenceWave() {
		return referenceWave;
	}
	public void setReferenceWave(boolean referenceWave) {
		this.surfingSince = AxeBot.getIt().getTime();
		this.referenceWave = referenceWave;
	}
	public int getDistToWall() {
		return distToWall;
	}

	public int getLastArrivalEstimatedDelta() {
		return lastArrivalEstimatedDelta;
	}
	public double getWeight() {
		return weight;
	}
	public double[] getResultGraph() {
		return resultGraph;
	}
	public AxeVector rayToGF(double gf2, Point2D.Double pos) {
		AxeVector gf = new AxeVector(this.getCenter(), this.getMyOriginalPos());
		AxeVector vec = new AxeVector(this.getCenter(), pos);
		double ray = pos.distance(this.getCenter());
		double arcWd = SegmentedGFs.getGFArcWdt(this.getBulletPower(), ray);
		double sliceWd = SegmentedGFs.getGFSliceWdt(arcWd);
		//posiciona no meio da gf inicial
		gf.addTheta((this.getDir() * (arcWd / 2D))
				+ (this.getDir() * -1 * (sliceWd / 2D)));
		gf.setModule(ray);
		return gf;
	}

	public static EnemyWave getNewestWave() {
		return newestWave;
	}
	/**
	 * @return
	 */
	public double getMyAttackAngle() {
		return myAttackAngle;
	}
}