package kawigi.spare.util;
import java.awt.geom.*;
import kawigi.spare.parts.*;
import robocode.*;
/**
 * ChooserBullet - an offensive virtual bullet to help pick the best virtual gun.
 */
public class ChooserBullet
{
	private String targetName;
	private Gun source;
	private double startx, starty, heading, bulletv, power;
	private long firetime, lasttime;
	public static final int HIT=1, MISS=-1, DONTKNOW=0;
	
	public ChooserBullet(String robot, double x, double y, double direction, double power, Gun fromGun, long currentTime)
	{
		targetName = robot;
		startx = x;
		starty = y;
		heading = direction;
		bulletv = 20-power/3;
		this.power = power;
		source = fromGun;
		firetime = currentTime;
		lasttime = firetime;
	}
	
	public double getX(long currentTime)
	{
		double distance = bulletv*(currentTime-firetime);
		return Math.sin(heading)*distance+startx;
	}
	
	public int hit(double ex, double ey, long time)
	{
		Line2D boundingLine = new java.awt.geom.Line2D.Double();
		java.awt.geom.Rectangle2D.Float boundingBox = new java.awt.geom.Rectangle2D.Float();
		boundingBox.setRect(ex - 18, ey - 18, 36, 36);
		double x = startx, y = starty, lastX = startx, lastY = starty;
		long timetemp = lasttime;
		while (timetemp <= time)
		{
			boundingLine.setLine(lastX, lastY, x, y);
			if (boundingBox.intersectsLine(boundingLine))
				return HIT;
			timetemp++;
			lastX = x;
			lastY = y;
			x = getX(timetemp);
			y = getY(timetemp);
		}
		lasttime = time;
		double distancetravelled = bulletv*(time-firetime);
		if (distancetravelled-18 > Math.sqrt((ex-startx)*(ex-startx)+(ey-starty)*(ey-starty)))
			return MISS;
		return DONTKNOW;
	}
	
	public double getY(long currentTime)
	{
		double distance = bulletv*(currentTime-firetime);
		return Math.cos(heading)*distance+starty;
	}
	
	public String getName()
	{
		return targetName;
	}
	
	public Gun getSource()
	{
		return source;
	}
	
	public double getPower()
	{
		return power;
	}
	
	public void aim(AdvancedRobot robot, EnemyState enemy)
	{
		double theta = heading-robot.getGunHeadingRadians();
		theta = ((theta + Math.PI)%(Math.PI*2)-Math.PI*2)%(Math.PI*2)+Math.PI;
		if (theta < 0)
			robot.setTurnGunLeftRadians(-theta);
		else if (theta > 0)
			robot.setTurnGunRightRadians(theta);
	}
}
