package jwst.DAD.SpecialRobots;

import robocode.*;

/***********************************************************************************
 * 
 * An abstract class in which the Robocode Events handed to it will be passed on
 * to any class that directly extends this class.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 *
 ***********************************************************************************/
public abstract class specializedRobot
{
    /**
     * A reference to the robot I will control if so be it a class should extend this abstract class
     */
    public AdvancedRobot robot;

    /**
     * A constructor to save away the passed robot to control
     * @param robot
     */
    public specializedRobot( AdvancedRobot robot )
    {
        this.robot = robot;
    }

    /**
     * Analogous to the first method called in any robocode round
     */
    public abstract void run();

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     *  
     * @param e - ScannedRobotEvent
     */
    public void onScannedRobot( ScannedRobotEvent e ) 
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - HitByBulletEvent
     */
    public void onHitByBullet( HitByBulletEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - HitRobotEvent
     */
    public void onHitRobot( HitRobotEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - HitWallEvent
     */
    public void onHitWall( HitWallEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - WinEvent
     */
    public void onWin( WinEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - DeathEvent
     */
    public void onDeath( DeathEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - BulletHitEvent
     */
    public void onBulletHit( BulletHitEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - BulletMissedEvent
     */
    public void onBulletMissed( BulletMissedEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - BulletHitBulletEvent
     */
    public void onBulletHitBullet( BulletHitBulletEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - RobotDeathEvent
     */
    public void onRobotDeath( RobotDeathEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param e - CustomEvent
     */
    public void onCustomEvent( CustomEvent e )
    {
        /*do nothing*/
    }

    /**
     * This method should be called in an executing robot class.
     * 
     * It will pass on the Robocode Event to an extending class.
     * 
     * @param g - Graphics2D
     */
    public void onPaint( java.awt.Graphics2D g )
    {
        /*do nothing*/
    }
}
