/*
 * Decompiled with CFR 0.152.
 */
package tex;

import tex.Longbot;
import tex.Program;

public class BotProgramming
extends Program {
    State myState = State.Patrol;

    @Override
    public void execute(Longbot bot) {
        switch (this.myState) {
            case Patrol: {
                bot.myPatrolProgram.execute(bot);
                break;
            }
            case EnemySighted: {
                break;
            }
            case EnemyLocked: {
                bot.myFireProgram.execute(bot);
                bot.myPatrolProgram.execute(bot);
                break;
            }
            case Searching: {
                bot.turnRadarRight(360.0);
            }
        }
        bot.execute();
    }

    @Override
    public void nextProgram(Longbot bot) {
        if (bot.getLastSeenEnemy() != null) {
            if (this.myState == State.EnemySighted) {
                this.myState = State.EnemyLocked;
            } else if (this.myState != State.EnemyLocked) {
                this.myState = State.EnemySighted;
            }
        } else if (this.myState == State.None) {
            this.myState = State.Searching;
        } else if (this.myState == State.Searching) {
            this.myState = State.Patrol;
        } else if (bot.getLastSeenEnemy() == null) {
            this.myState = State.Searching;
        }
    }

    static enum State {
        None,
        Patrol,
        EnemySighted,
        EnemyLocked,
        Searching;

    }
}

