/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.mega.index;

import lazarecki.mega.index.Index;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.HistoryTrackingModule;

public class VelocityChangeIndex
implements Index {
    private HistoryTrackingModule historyModule;
    private boolean invert;

    public VelocityChangeIndex(HistoryTrackingModule historyModule, boolean invert) {
        this.historyModule = historyModule;
        this.invert = invert;
    }

    public HistoryTrackingModule getHistoryModule() {
        return this.historyModule;
    }

    public void setHistoryModule(HistoryTrackingModule historyModule) {
        this.historyModule = historyModule;
    }

    @Override
    public String getName() {
        return "VelocityChange";
    }

    @Override
    public int getSegmentIndex(RobotInfo me, RobotInfo enemy) {
        if (this.getHistoryModule().getEntries() < 2) {
            return 0;
        }
        RobotInfo before = !this.invert ? this.getHistoryModule().getTargetInfo(1) : this.getHistoryModule().getMyInfo(1);
        RobotInfo now = !this.invert ? this.getHistoryModule().getTargetInfo(0) : this.getHistoryModule().getMyInfo(0);
        double difference = Math.abs(before.getVelocity()) - Math.abs(now.getVelocity());
        if (difference < 0.0) {
            return 0;
        }
        if (difference > 0.0) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getSegments() {
        return 3;
    }
}

