/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;

public class BattleStats {
    private long mNumTotalTurns = 0L;
    private long mNumTurnsSkipped = 0L;
    private long mNumShotsFired = 0L;
    private long mNumShotsHit = 0L;
    private long mNumShotsMissed = 0L;
    private long mNumBulletCollisions = 0L;
    private final NumberFormat dp2 = NumberFormat.getInstance();
    private static BattleStats THE_INSTANCE = new BattleStats();

    public static BattleStats getInstance() {
        return THE_INSTANCE;
    }

    private BattleStats() {
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
    }

    public void endRound(long numTotalTurns, long numTurnsSkipped, long numShotsFired, long numShotsHit, long numShotsMissed, long numBulletCollisions) {
        this.mNumTotalTurns += numTotalTurns;
        this.mNumTurnsSkipped += numTurnsSkipped;
        this.mNumShotsFired += numShotsFired;
        this.mNumShotsHit += numShotsHit;
        this.mNumShotsMissed += numShotsMissed;
        this.mNumBulletCollisions += numBulletCollisions;
        this.printStats();
    }

    private void printStats() {
        double hitPct = 0.0;
        long totalResolvedShots = this.mNumShotsHit + this.mNumShotsMissed;
        if (totalResolvedShots > 0L) {
            hitPct = 100.0 * (double)this.mNumShotsHit / (double)totalResolvedShots;
        }
        double skipPct = 100.0 * (double)this.mNumTurnsSkipped / (double)this.mNumTotalTurns;
        System.out.println();
        System.out.println("========== Battle stats ==========");
        System.out.println("Shots/HitBlt/Remain: " + this.mNumShotsFired + " / " + this.mNumBulletCollisions + " / " + (this.mNumShotsFired - this.mNumBulletCollisions));
        System.out.println("Hit/Missed/HitPct:   " + this.mNumShotsHit + " / " + this.mNumShotsMissed + " / " + this.dp2.format(hitPct) + "%");
        System.out.println("Turns/Skips/SkipPct: " + this.mNumTotalTurns + " / " + this.mNumTurnsSkipped + " / " + this.dp2.format(skipPct) + "%");
        System.out.println();
    }
}

