/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.awt.Color;
import java.text.NumberFormat;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import shrub.BHPredictor;
import shrub.Bearing;
import shrub.BodyInstruction;
import shrub.Box;
import shrub.CPPredictor;
import shrub.GunController;
import shrub.GunInstruction;
import shrub.GunPhysics;
import shrub.Heading;
import shrub.Location;
import shrub.MHTracker;
import shrub.MoveHistory;
import shrub.MoveMgrMelee;
import shrub.MultiPData;
import shrub.Navigator;
import shrub.PHPredictor;
import shrub.RadarInstruction;
import shrub.RadarMgrMelee;
import shrub.RobotDataStore;
import shrub.RoundStats;
import shrub.ShrubMath;
import shrub.Sighting;
import shrub.TurretInstruction;
import shrub.TurretMgrWaggle;

public final class Vapour
extends AdvancedRobot {
    private final String mBotName = "Vapour v159";
    private RobotDataStore mDataStore = RobotDataStore.getInstance();
    private GunPhysics mGunPhysics = GunPhysics.getInstance();
    private Box mArena = null;
    private GunController mGun = GunController.getInstance();
    private MHTracker mTracker = new MHTracker();
    private Navigator mNavigator = Navigator.getInstance();
    private MultiPData mMultiPData = null;
    private RadarMgrMelee mRadarMgr = null;
    private TurretMgrWaggle mTurretMgr = null;
    private MoveMgrMelee mMoveMgr = null;
    private CPPredictor mCPPredictor = new CPPredictor();
    private BHPredictor mBHPredictor = new BHPredictor();
    private PHPredictor mPHPredictor = new PHPredictor();
    private long mTimeFirstFireAllowed = 0L;
    private long mTimeFirstMoveAllowed = 0L;
    private static NumberFormat dp2 = NumberFormat.getInstance();
    private final RoundStats mRoundStats = RoundStats.getInstance();

    private void initialise() {
        this.setColors(Color.green, Color.blue, Color.white);
        this.populateDataStore();
        double robotWidth = this.getWidth();
        double robotHeight = this.getHeight();
        double robotRadius = (robotWidth + robotHeight) / 4.0;
        ShrubMath.SetRobotRadius(robotRadius);
        ShrubMath.Initialise();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        Location corner1 = Location.ZERO_ZERO;
        Location corner2 = Location.valueOf(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.mArena = Box.valueOf(corner1, corner2);
        this.mNavigator.SetArena(this.mArena);
        Location corner3 = Location.valueOf(robotRadius - 5.0, robotRadius - 5.0);
        Location corner4 = Location.valueOf(this.getBattleFieldWidth() - robotRadius + 5.0, this.getBattleFieldHeight() - robotRadius + 5.0);
        Box movementArea = Box.valueOf(corner3, corner4);
        this.mTracker.SetMaxHistory(160);
        this.mMultiPData = new MultiPData(4, 20, 1, 60, 100.0);
        this.mBHPredictor.SetInterceptArea(movementArea);
        this.mBHPredictor.SetMaxInterceptTime(75L);
        this.mBHPredictor.SetMaxAngleOverride(30L);
        this.mPHPredictor.SetInterceptArea(movementArea);
        this.mPHPredictor.SetMaxInterceptTime(75L);
        this.mPHPredictor.SetPeriodicity(50);
        this.mPHPredictor.SetMaxAngleOverride(30L);
        this.mMultiPData.SetTrackerRef(this.mTracker);
        this.mNavigator.SetTrackerRef(this.mTracker);
        this.mGun.SetTrackerRef(this.mTracker);
        this.mGun.SetCPPredictor(this.mCPPredictor);
        this.mGun.SetBHPredictor(this.mBHPredictor);
        this.mGun.SetPHPredictor(this.mPHPredictor);
        this.mTimeFirstFireAllowed = this.mGunPhysics.howLongUntilICanFire();
        this.mTimeFirstMoveAllowed = this.mTimeFirstFireAllowed - 15L;
        this.mTracker.SetStalenessLimit(20L);
        this.mTracker.SetEvalDistanceCoeff(1.0);
        this.mTracker.SetEvalAngleCoeff(1.0);
        this.mTracker.SetEvalSpeedCoeff(0.0);
        this.mTracker.SetEvalStaleCoeff(0.0);
        this.mTracker.SetEvalDisabledThreshold(0.001);
        this.mTracker.SetEvalDisabledBonus(300.0);
        this.mTracker.SetEvalLowEnergyThreshold(0.5);
        this.mTracker.SetEvalLowEnergyBonus(-1000.0);
        this.mTracker.SetExtrapolationInterval(1);
        Location myLocn = this.mDataStore.getMyLocn();
        System.out.println();
        System.out.println("-*- Vapour v159 -*-");
        System.out.println("Starting locn: " + myLocn.toString());
        System.out.println("Robot width:   " + dp2.format(robotWidth));
        System.out.println("Robot height:  " + dp2.format(robotHeight));
        System.out.println("Robot radius:  " + dp2.format(robotRadius));
        System.out.println("Fire allowed:  " + this.mTimeFirstFireAllowed);
        System.out.println("Move allowed:  " + this.mTimeFirstMoveAllowed);
    }

    private void initialiseComponentMgrs() {
        this.mRadarMgr = new RadarMgrMelee(this.mTracker);
        this.mTurretMgr = new TurretMgrWaggle(this.mTracker);
        this.mMoveMgr = new MoveMgrMelee(this.mTracker);
        this.mTracker.SetRadarResyncRef(this.mRadarMgr);
        Location myLocn = this.mDataStore.getMyLocn();
        this.mMoveMgr.setWaypointExternal(myLocn);
    }

    private void populateDataStore() {
        this.mDataStore.setCurrentTime(this.getTime());
        this.mDataStore.setMyLocn(Location.valueOf(this.getX(), this.getY()));
        this.mDataStore.setMyHdng(Heading.valueOf(this.getHeading()));
        this.mDataStore.setMyRadarHdng(Heading.valueOf(this.getRadarHeading()));
        this.mDataStore.setMyGunHdng(Heading.valueOf(this.getGunHeading()));
        this.mDataStore.setMyGunHeat(this.getGunHeat());
        this.mDataStore.setMyEnergy(this.getEnergy());
        this.mDataStore.setNumOthers(this.getOthers());
    }

    public void run() {
        this.initialise();
        this.initialiseComponentMgrs();
        this.mRoundStats.initialise();
        while (true) {
            this.populateDataStore();
            this.mGun.SetGunHdng(this.mDataStore.getMyGunHdng());
            this.mGun.SetGunLocn(this.mDataStore.getMyLocn());
            this.mGun.SetTime(this.mDataStore.getCurrentTime());
            this.mTracker.SetCurrentTime(this.mDataStore.getCurrentTime());
            this.mTracker.SetTrackerLocn(this.mDataStore.getMyLocn());
            this.mTracker.SetGunHdng(this.mDataStore.getMyGunHdng());
            this.mTracker.ExtrapolateAll(this.mDataStore.getCurrentTime());
            this.mTracker.ChooseBestTarget();
            Sighting currentTarget = this.mTracker.GetCurrentTarget();
            double targetEnergy = -1.0;
            MoveHistory targetHist = null;
            if (currentTarget != null) {
                targetEnergy = currentTarget.GetEnergy();
                targetHist = this.mTracker.GetCurrentTargetHistory();
            }
            int bestPeriod = -1;
            if (this.mDataStore.getNumOthers() <= 10L && targetHist != null && this.mDataStore.getCurrentTime() > 50L) {
                if (!this.mGunPhysics.amIReadyToFire()) {
                    if (this.mTracker.GetNumFreshTargets() == 1) {
                        this.mMultiPData.SetValueThreshold(50.0);
                    } else {
                        this.mMultiPData.SetValueThreshold(100.0);
                    }
                    this.mMultiPData.DoNextPeriodicityCalcs();
                } else {
                    bestPeriod = this.mMultiPData.GetBestPeriodForTarget(targetHist.GetName());
                }
            }
            RadarInstruction radarInstruct = this.mRadarMgr.GenerateInstruction();
            TurretInstruction turretInstruct = this.mTurretMgr.generateInstruction();
            if (this.mDataStore.getNumOthers() == 0L) {
                this.mGun.SetMode(0);
            } else if (!this.mTracker.HasLockOn()) {
                this.mGun.SetMode(0);
            } else if (this.mGunPhysics.amIReadyToFire()) {
                int gunMode = 0;
                if (targetEnergy < 0.001) {
                    gunMode = 3;
                } else if (bestPeriod > 0) {
                    this.mPHPredictor.SetPeriodicity(bestPeriod);
                    gunMode = 4;
                } else {
                    gunMode = 2;
                }
                double maxPower = 0.0;
                double minPower = 0.0;
                double closestTgtDist = this.mTracker.FindDistanceToClosestFreshTarget();
                if (closestTgtDist < 200.0) {
                    maxPower = GunPhysics.maxLegalPwr();
                    minPower = 2.0;
                } else if (closestTgtDist < 400.0) {
                    maxPower = GunPhysics.maxLegalPwr();
                    minPower = 1.0;
                } else if (closestTgtDist < 600.0) {
                    maxPower = GunPhysics.maxLegalPwr();
                    minPower = 0.5;
                } else {
                    maxPower = GunPhysics.maxLegalPwr();
                    minPower = GunPhysics.minLegalPwr();
                }
                if (targetEnergy < 0.001) {
                    maxPower = GunPhysics.minLegalPwr() + 0.01;
                    minPower = GunPhysics.minLegalPwr();
                } else {
                    double pwrNeeded = GunPhysics.pwrFromDmg(targetEnergy);
                    if (pwrNeeded > 0.0 && pwrNeeded < maxPower) {
                        maxPower = pwrNeeded;
                    }
                    if (this.mDataStore.getMyEnergy() <= maxPower) {
                        maxPower = this.mDataStore.getMyEnergy() - 0.01;
                    }
                    if (maxPower <= minPower) {
                        minPower = GunPhysics.minLegalPwr();
                    }
                }
                this.mGun.SetMode(gunMode);
                this.mGun.SetMinPower(minPower);
                this.mGun.SetMaxPower(maxPower);
            } else {
                this.mGun.SetMode(0);
            }
            GunInstruction gunInstruct = this.mGun.GenerateInstruction();
            BodyInstruction[] bodyInstructs = this.mMoveMgr.generateInstructions();
            for (int index = 0; index < bodyInstructs.length; ++index) {
                this.resolveBodyInstruct(bodyInstructs[index]);
            }
            this.resolveTurretInstruct(turretInstruct);
            this.resolveRadarInstruct(radarInstruct);
            if (gunInstruct.getType() == GunInstruction.FIRE) {
                double power = gunInstruct.getValue();
                this.mRoundStats.shotFired(this.mDataStore.getCurrentTime(), power);
            }
            this.resolveGunInstruct(gunInstruct);
            if (gunInstruct.getType() == GunInstruction.FIRE) continue;
            this.execute();
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.mRoundStats.skippedTurn();
    }

    public void onBulletHit(BulletHitEvent event) {
        this.mRoundStats.shotHit();
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.mRoundStats.shotMissed();
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.mRoundStats.bulletCollision();
    }

    public void onDeath(DeathEvent event) {
        System.out.println();
        System.out.println("Dead, " + this.getOthers() + " still alive");
        this.mTracker.RemoveAll();
        System.gc();
        this.mRoundStats.endRound(this.getTime());
    }

    public void onWin(WinEvent event) {
        System.out.println();
        System.out.println("Rah! Rah! 2-4-6-8 Rah! etc.");
        System.out.println();
        this.mTracker.RemoveAll();
        System.gc();
        this.mRoundStats.endRound(this.getTime());
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        Heading robotHdng = Heading.valueOf(this.getHeading());
        Bearing bearingTo = Bearing.valueOf(event.getBearing());
        Heading contactHdng = Heading.valueOf(event.getHeading());
        Heading headingTo = Heading.valueOfAdjust(robotHdng, bearingTo);
        Location robotLocn = Location.valueOf(this.getX(), this.getY());
        Location contactLocn = Location.valueOfRelative(robotLocn, headingTo, event.getDistance());
        int contactInaccuracy = 0;
        Sighting sighting = Sighting.valueOf(event.getName(), event.getVelocity(), contactLocn, contactHdng, event.getEnergy(), contactInaccuracy, event.getTime());
        this.mTracker.ReportSighting(sighting);
        this.mMultiPData.ReportSighting(event.getName());
    }

    public void onHitWall(HitWallEvent event) {
        this.mRoundStats.hitWall();
        this.mMoveMgr.actOnRobotHitWall();
    }

    public void onHitRobot(HitRobotEvent event) {
        if (event.isMyFault()) {
            this.mRoundStats.rammerOfRobot();
        } else {
            this.mRoundStats.rammedByRobot();
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.mRoundStats.hitByBullet();
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.mTracker.ReportRobotDeath(event.getName());
        this.mMultiPData.ReportRobotDeath(event.getName());
    }

    private void resolveBodyInstruct(BodyInstruction instruct) {
        if (instruct.getType() != BodyInstruction.NOTHING && instruct.getType() != BodyInstruction.ENDED) {
            if (instruct.getType() == BodyInstruction.TURN_LEFT) {
                this.setTurnLeft(instruct.getValue());
            } else if (instruct.getType() == BodyInstruction.TURN_RIGHT) {
                this.setTurnRight(instruct.getValue());
            } else if (instruct.getType() == BodyInstruction.MOVE_AHEAD) {
                this.setAhead(instruct.getValue());
            } else if (instruct.getType() == BodyInstruction.MOVE_BACK) {
                this.setBack(instruct.getValue());
            } else if (instruct.getType() == BodyInstruction.SPEED_LIMIT) {
                System.out.println("Speed limit: " + instruct.getValue());
                this.setMaxVelocity(instruct.getValue());
            } else {
                System.out.println("ERROR : ResolveBodyInstruct, unexpected type");
            }
        }
    }

    private void resolveTurretInstruct(TurretInstruction instruct) {
        if (instruct.GetType() != TurretInstruction.NONE) {
            if (instruct.GetType() == TurretInstruction.LEFT) {
                this.setTurnGunLeft(instruct.GetValue());
            } else if (instruct.GetType() == TurretInstruction.RIGHT) {
                this.setTurnGunRight(instruct.GetValue());
            } else {
                System.out.println("ERROR : ResolveTurretInstruct, unexpected type");
            }
        }
    }

    private void resolveRadarInstruct(RadarInstruction instruct) {
        if (instruct.getType() != RadarInstruction.NONE) {
            if (instruct.getType() == RadarInstruction.LEFT) {
                this.setTurnRadarLeft(instruct.getValue());
            } else if (instruct.getType() == RadarInstruction.RIGHT) {
                this.setTurnRadarRight(instruct.getValue());
            } else {
                System.out.println("ERROR : ResolveRadarInstruct, unexpected type");
            }
        }
    }

    private void resolveGunInstruct(GunInstruction gunInstruct) {
        if (gunInstruct.getType() != GunInstruction.NONE) {
            if (gunInstruct.getType() == GunInstruction.FIRE) {
                this.fire(gunInstruct.getValue());
            } else if (gunInstruct.getType() == GunInstruction.LEFT) {
                this.setTurnGunLeft(gunInstruct.getValue());
            } else if (gunInstruct.getType() == GunInstruction.RIGHT) {
                this.setTurnGunRight(gunInstruct.getValue());
            } else {
                System.out.println("ERROR : ResolveGunInstruct, unexpected type");
            }
        }
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

