/*
 * Decompiled with CFR 0.152.
 */
package rdt.Debug;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.util.Utils;

public class DebugGraph {
    private ArrayList<Point> _points = new ArrayList();
    private int _maxPoints;
    private double _minVal;
    private double _maxVal;
    private Point2D.Double _minExtents;
    private Point2D.Double _maxExtents;

    public DebugGraph(int maxPoints, double minVal, double maxVal, Point2D.Double minExtents, Point2D.Double maxExtents) {
        this._maxPoints = maxPoints;
        this._minVal = minVal;
        this._maxVal = maxVal;
        this._minExtents = minExtents;
        this._maxExtents = maxExtents;
    }

    public void AddPoint(double val) {
        Point newPoint = new Point();
        newPoint.Value = val;
        this._points.add(newPoint);
        if (this._points.size() > this._maxPoints) {
            this._points.remove(0);
        }
    }

    public void Draw(Graphics2D gfx) {
        double x = this._minExtents.x;
        double y = this._minExtents.y;
        double width = this._maxExtents.x - x;
        double height = this._maxExtents.y - y;
        double scale = height / (this._maxVal - this._minVal);
        double zeroY = (this._maxVal - this._minVal) / 2.0 * scale + y;
        if (this._minVal >= 0.0) {
            zeroY = y;
        }
        width /= (double)this._maxPoints;
        gfx.setColor(Color.gray);
        int index = 0;
        while (index < this._points.size()) {
            double val = this._points.get((int)index).Value;
            if (Utils.isNear((double)val, (double)0.0)) {
                x += width;
            } else {
                if (val > 0.0) {
                    y = (int)zeroY;
                    height = (int)(val * scale);
                } else {
                    height = (int)(Math.abs(val) * scale);
                    y = (double)((int)zeroY) - height;
                }
                gfx.drawRect((int)x, (int)y, (int)width, (int)height);
                x += width;
            }
            ++index;
        }
        gfx.setColor(Color.white);
        gfx.drawRect((int)this._minExtents.x, (int)this._minExtents.y, (int)(this._maxExtents.x - this._minExtents.x), (int)(this._maxExtents.y - this._minExtents.y));
    }

    private class Point {
        double Value;

        private Point() {
        }
    }
}

