/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.HasWave;
import pedersen.util.TargetingStatistics;

public class FiringSolution
extends DebuggableBase
implements HasDirection {
    private final Direction absoluteHeading;
    private final TargetingStatistics ts0;
    private TargetingStatistics ts1 = null;
    private boolean statisticsHaveBeenRecorded = false;
    public static long counter = 0L;
    public static long release = 0L;

    public FiringSolution(Direction direction, TargetingStatistics stats) {
        this.absoluteHeading = direction;
        this.ts0 = stats;
        ++counter;
    }

    @Override
    public Direction getDirection() {
        return this.absoluteHeading;
    }

    public void registerHit(HasWave wave) {
        if (!this.statisticsHaveBeenRecorded) {
            if (this.ts0 != null) {
                this.ts0.registerHit(wave);
            }
            if (this.ts1 != null) {
                this.ts1.registerHit(wave);
            }
        }
        this.statisticsHaveBeenRecorded = true;
    }

    public void registerMiss(HasWave wave) {
        if (!this.statisticsHaveBeenRecorded) {
            if (this.ts0 != null) {
                this.ts0.registerMiss(wave);
            }
            if (this.ts1 != null) {
                this.ts1.registerMiss(wave);
            }
        }
        this.statisticsHaveBeenRecorded = true;
    }

    public double getSuccessRate() {
        if (!this.statisticsHaveBeenRecorded) {
            return this.ts0.getSuccessRate();
        }
        return 0.0;
    }

    public void associateTargetingStatistics(TargetingStatistics stats) {
        if (this.ts0 != null && this.ts0 == stats) {
            System.out.println("Doubling up on targeting statistics in Firing Solution.");
        }
        this.ts1 = stats;
    }

    @Override
    public String description() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append(this.absoluteHeading.description());
        buffer.append("\n").append(this.ts0.description());
        return buffer.toString();
    }

    public void release() {
        ++release;
    }
}

