/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import java.util.Set;
import pedersen.debug.DebuggableBase;
import pedersen.util.Constraints;

public class BearingOffsetRange
extends DebuggableBase {
    private double min;
    private double max;

    public BearingOffsetRange(double o) {
        this.min = o;
        this.max = o;
        this.integrityCheck();
    }

    public BearingOffsetRange(double v1, double v2) {
        this.min = Math.min(v1, v2);
        this.max = Math.max(v1, v2);
        this.integrityCheck();
    }

    public BearingOffsetRange(BearingOffsetRange other) {
        this.min = other.min;
        this.max = other.max;
        this.integrityCheck();
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public void add(double o) {
        this.min = Math.min(this.min, o);
        this.max = Math.max(this.max, o);
        this.integrityCheck();
    }

    public void add(BearingOffsetRange other) {
        this.add(other.min());
        this.add(other.max());
    }

    public BearingOffsetRange translate(double bearing) {
        double min = Constraints.getNegativePiToPi(this.min + bearing);
        double max = Constraints.getNegativePiToPi(this.max + bearing);
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
        return new BearingOffsetRange(this.min, this.max);
    }

    public double getFactoredBearingOffset(double factor) {
        double factoredBearingOffset = 0.0;
        factoredBearingOffset = this.min < 0.0 ? (this.max < 0.0 ? -factor * (this.min - this.max) + this.max : factor * (factor < 0.0 ? -this.min() : this.max())) : factor * (this.max - this.min) + this.min;
        factoredBearingOffset = Constraints.limitValue(this.min, factoredBearingOffset, this.max);
        return factoredBearingOffset;
    }

    public boolean isInRange(double r) {
        return Constraints.isInRange(this.min, r, this.max);
    }

    public boolean overlaps(BearingOffsetRange other) {
        return this.isInRange(other.min) || this.isInRange(other.max) || other.isInRange(this.min) || other.isInRange(this.max);
    }

    private void integrityCheck() {
        this.integrityCheck(this.min());
        this.integrityCheck(this.max());
    }

    private void integrityCheck(double value) {
        if (value != Constraints.getNegativePiToPi(value)) {
            throw new RuntimeException("Bearing offset range value out of range: " + value);
        }
    }

    @Override
    public String description() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ " + super.trim(this.min()) + ", " + super.trim(this.max()) + " ]";
    }

    public boolean equals(BearingOffsetRange other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Constraints.areEqual(this.min, other.min) && Constraints.areEqual(this.max, other.max);
    }

    public static final Set<BearingOffsetRange>[] getArrayOfSets(int length) {
        return new Set[length];
    }
}

