/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import pedersen.util.BaseConversions;
import pedersen.util.Constraints;
import pedersen.util.Conversions;
import robocode.Rules;

public class BaseConstraints {
    public static final double maxFirepower = 3.0;
    public static final double minFirepower = 0.1;
    public static final double maxBulletVelocity = Rules.getBulletSpeed((double)0.1);
    public static final double minBulletVelocity = Rules.getBulletSpeed((double)3.0);
    public static final double maxAbsVehicleVelocity = 8.0;
    public static final double maxAbsVehicularTurnRate = Rules.MAX_TURN_RATE_RADIANS;
    public static final double maxAbsTurretTurnRate = Rules.GUN_TURN_RATE_RADIANS;
    public static final double maxAbsRadarTurnRate = Rules.RADAR_TURN_RATE_RADIANS;
    public static final double maxAbsVehicularAcceleration = 1.0;
    public static final double maxAbsVehicularDeceleration = 2.0;
    public static final double maxEscapeAngle = Math.asin(8.0 / minBulletVelocity);
    public static final double halfCircle = Math.PI;
    public static final double fullCircle = Math.PI * 2;
    public static final double rightAngle = 1.5707963267948966;
    public static final double rightAngleNeg = -1.5707963267948966;
    public static final double doubleErrorTolerance = 1.0E-6;
    public static final double vehicleRadius = Conversions.getHypoteneuse(18.0, 18.0);
    public static final boolean allowFileIO = true;

    public static boolean isInRange(double minimum, double value, double maximum) {
        return minimum < value && value < maximum || Constraints.areEqual(minimum, value) || Constraints.areEqual(value, maximum);
    }

    public static boolean isInRange(int minimum, int value, int maximum) {
        return minimum <= value && value <= maximum;
    }

    public static double getNegativePiToPi(double radians) {
        if ((radians %= Math.PI * 2) > Math.PI) {
            radians -= Math.PI * 2;
        } else if (-radians > Math.PI) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public static double getZeroToTwoPi(double radians) {
        if ((radians %= Math.PI * 2) < 0.0) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public static boolean areEqual(double a, double b) {
        return BaseConstraints.isApproximatelyZero(b - a);
    }

    public static boolean isApproximatelyZero(double delta) {
        return Math.abs(delta) < 1.0E-6;
    }

    public static boolean isFirepowerLegal(double firepower) {
        return BaseConstraints.isInRange(0.1, firepower, 3.0);
    }

    public static double limitFirepower(double firepower) {
        return BaseConstraints.limitValue(0.1, firepower, 3.0);
    }

    public static double limitBulletVelocity(double velocity) {
        return BaseConstraints.limitValue(minBulletVelocity, velocity, maxBulletVelocity);
    }

    public static double limitChassisRotation(double rotation) {
        return BaseConstraints.limitValue(-maxAbsVehicularTurnRate, rotation, maxAbsVehicularTurnRate);
    }

    public static double limitTurretRotation(double rotation) {
        return BaseConstraints.limitValue(-maxAbsTurretTurnRate, rotation, maxAbsTurretTurnRate);
    }

    public static double limitScannerRotation(double rotation) {
        return BaseConstraints.limitValue(-maxAbsRadarTurnRate, rotation, maxAbsRadarTurnRate);
    }

    public static double limitChassisVelocity(double velocity) {
        return BaseConstraints.limitValue(-8.0, velocity, 8.0);
    }

    public static double limitChassisAcceleration(double acceleration) {
        return BaseConstraints.limitValue(-1.0, acceleration, 1.0);
    }

    public static double limitChassisDecelleration(double deceleration) {
        return BaseConstraints.limitValue(-2.0, deceleration, 2.0);
    }

    public static boolean isRelativeBearingToRear(double relativeBearing) {
        return !BaseConstraints.isInRange(-1.5707963267948966, relativeBearing, 1.5707963267948966);
    }

    public static boolean isVelocityAbleToAchieveTurnRadius(double velocity, double radius) {
        double maximumTurnRate = Conversions.getAbsMaxTurnRateFromVelocity(velocity);
        double theta = BaseConversions.getTurnRateFromTurnRadiusAndVelocity(radius, velocity);
        return theta <= maximumTurnRate;
    }

    public static double limitValue(double minimum, double value, double maximum) {
        return Math.min(Math.max(minimum, value), maximum);
    }

    public static int limitValue(int minimum, int value, int maximum) {
        return Math.min(Math.max(minimum, value), maximum);
    }
}

