/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pedersen.physics.StaticPosition;

public class Conversions {
    private static final double maxAbsVehicularTurnRate = 0.17453292519943295;
    private static final double vehicularTurnRateScalar = 0.01308996938995747;

    public static double getBulletDamageFromFirepower(double firepower) {
        return Math.max(firepower * 4.0, firepower * 4.0 + (firepower - 1.0) * 2.0);
    }

    public static double getBulletVelocityFromFirepower(double firepower) {
        return 20.0 - 3.0 * firepower;
    }

    public static double getFirepowerFromBulletVelocity(double velocity) {
        return (20.0 - velocity) / 3.0;
    }

    public static double getAbsMaxTurnRateFromVelocity(double velocity) {
        return 0.17453292519943295 - 0.01308996938995747 * Math.abs(velocity);
    }

    public static double getAbsVelocityFromMaxTurnRate(double turnRate) {
        return (0.17453292519943295 - Math.abs(turnRate)) / 0.01308996938995747;
    }

    public static double getEnergyRewardFromFirepower(double firepower) {
        return 3.0 * firepower;
    }

    public static double getFirepowerFromEnergyReward(double energy) {
        return energy / 3.0;
    }

    public static Rectangle2D.Double getRectangle2DForRobot(StaticPosition center) {
        return new Rectangle2D.Double(center.getX() - 18.0, center.getY() - 18.0, 36.0, 36.0);
    }

    public static Point2D.Double getPoint2D(StaticPosition center) {
        return new Point2D.Double(center.getX(), center.getY());
    }
}

