/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mini;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Partial
extends AdvancedRobot {
    public static double enemyEnergy = 100.0;
    static ArrayList<Point2D.Double> enemyLocations = new ArrayList();
    static ArrayList<double[]> past = new ArrayList();
    static ArrayList<Wave> waves = new ArrayList();
    static Point2D.Double location;
    static Point2D.Double enemyLocation;
    static Rectangle2D.Double battleField;
    static ArrayList<Object[]> hits;
    static int enemyFired;
    static String enemyHistory;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        waves.clear();
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double firePower;
        int i;
        int n;
        int matchPos;
        double d;
        double absBearing = e.getBearingRadians();
        double latVel = this.getVelocity() * Math.sin(absBearing);
        double advVel = this.getVelocity() * Math.cos(absBearing);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)((absBearing += this.getHeadingRadians()) - this.getRadarHeadingRadians())) * 2.0);
        location = new Point2D.Double(this.getX(), this.getY());
        double distance = e.getDistance();
        enemyLocation = Partial.project(location, absBearing, distance);
        enemyLocations.add(0, (Point2D.Double)enemyLocation.clone());
        past.add(0, new double[]{Math.abs(latVel / 8.0), advVel / 16.0 + 0.5, distance / 1000.0, absBearing});
        this.updateWaves();
        double d2 = enemyEnergy;
        enemyEnergy = e.getEnergy();
        double deltaEnergy = d2 - enemyEnergy;
        if (d > 0.099 && deltaEnergy < 3.01) {
            Wave w = new Wave();
            w.source = enemyLocations.get(2);
            w.distanceTraveled = w.velocity = 20.0 - 3.0 * deltaEnergy;
            w.data = past.get(2);
            w.absBearing = w.data[3] + Math.PI;
            w.dir = (int)Math.signum(latVel + 1.0E-6);
            waves.add(w);
        }
        if (!waves.isEmpty()) {
            Wave surfWave = waves.get(0);
            int direction = (int)Math.signum(this.predictDanger(surfWave, -1) - this.predictDanger(surfWave, 1) + 1.0E-6);
            double moveAngle = this.wallSmoothing(location, absBearing + (double)(direction * 2), direction) - this.getHeadingRadians();
            this.setAhead(Math.cos(moveAngle) * Double.POSITIVE_INFINITY);
            this.setTurnRightRadians(Math.tan(moveAngle));
        }
        int matchLen = 30;
        enemyHistory = String.valueOf((char)(e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing))).concat(enemyHistory);
        do {
            n = matchLen--;
            firePower = Math.max(Math.min(3.0, Math.max(Math.min(Math.min(1.95, this.getEnergy() / 20.0), e.getEnergy() / 4.0), 250.0 / distance)), 0.1);
            i = (int)(distance / (20.0 - 3.0 * firePower));
        } while ((matchPos = enemyHistory.indexOf(enemyHistory.substring(0, n), i)) < 0);
        do {
            absBearing += (double)((short)enemyHistory.charAt(--matchPos)) / distance;
        } while (--i > 0);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians())) + Math.random() * 0.02 - 0.01);
        this.setFire(firePower);
    }

    public void updateWaves() {
        for (int i = 0; i < waves.size(); ++i) {
            double d;
            Wave w = waves.get(i);
            w.distanceTraveled += w.velocity;
            if (!(d > w.source.distance(location))) continue;
            waves.remove(i--);
        }
    }

    public double predictDanger(Wave surfWave, int direction) {
        double moveAngle;
        Point2D.Double predictedPosition = (Point2D.Double)location.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            moveAngle = this.wallSmoothing(predictedPosition, Partial.absoluteBearing(surfWave.source, predictedPosition) + (double)(direction * 2), direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Partial.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Partial.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Partial.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.source) < surfWave.distanceTraveled + (double)counter * surfWave.velocity + surfWave.velocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        predictedVelocity = 0.0;
        moveAngle = this.getGF(surfWave, predictedPosition);
        for (int i = 0; i < hits.size(); ++i) {
            predictedHeading = 1.0;
            Object[] hitPoint = hits.get(i);
            double[] point = (double[])hitPoint[0];
            for (int j = 0; j < 3; ++j) {
                predictedHeading += Math.abs(point[j] - surfWave.data[j]);
            }
            predictedVelocity += Math.abs(moveAngle - (Double)hitPoint[1]) / predictedHeading;
        }
        return predictedVelocity;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!battleField.contains(Partial.project(botLocation, angle, 160.0))) {
            angle -= (double)orientation * 0.05;
        }
        return angle;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!waves.isEmpty()) {
            Wave hitWave = null;
            for (int x = 0; x < waves.size(); ++x) {
                Wave wave;
                Wave ew = waves.get(x);
                if (!(Math.abs(wave.distanceTraveled - location.distance(ew.source)) < 50.0) || !(Math.abs(e.getBullet().getVelocity() - ew.velocity) < 0.001)) continue;
                hitWave = ew;
                break;
            }
            this.logHit(hitWave, new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
            waves.remove(hitWave);
        }
    }

    public void logHit(Wave w, Point2D.Double location) {
        hits.add(new Object[]{w.data, this.getGF(w, location)});
    }

    public double getGF(Wave w, Point2D.Double location) {
        return Utils.normalRelativeAngle((double)(Partial.absoluteBearing(w.source, location) - w.absBearing)) * (double)w.dir / Math.asin(8.0 / w.velocity);
    }

    static {
        battleField = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        hits = new ArrayList();
        enemyFired = 0;
        enemyHistory = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffe\ufffc\ufffa\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff9\ufffa\ufffb\ufffc\ufffd\ufffe\uffff\u0000\u0002\u0004\u0006\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\u0007\u0006\u0005\u0004\u0003\u0002\u0001\u0000";
    }

    public class Wave {
        Point2D.Double source;
        double[] data;
        double distanceTraveled;
        double velocity;
        double absBearing;
        int dir;
    }
}

