/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.AtomicMove;
import alk.lap.strategy.BotRecord;
import alk.lap.strategy.Move;
import alk.lap.utils.DVektor;

public class ScanRecord
implements BotRecord {
    private long scanTime = 0L;
    private String botName = null;
    AtomicMove atomicMove = null;
    public double power;
    public DVektor pos;
    public double bearingToScanner;
    public double distanceToScanner;
    public Move move;

    public ScanRecord(String name, long scanTime) {
        this.botName = name;
        this.scanTime = scanTime;
        this.atomicMove = new AtomicMove();
        this.distanceToScanner = -1.0;
        this.pos = new DVektor();
        this.bearingToScanner = 0.0;
        this.power = 3.0;
        this.move = null;
    }

    public String getBotName() {
        return this.botName;
    }

    public long getScanTime() {
        return this.scanTime;
    }

    public String toString() {
        return "t=" + this.scanTime + " '" + this.botName + "' scanned with:" + " v=" + LoudAndProud.printStaticDouble(this.atomicMove.velocity) + " head=" + LoudAndProud.printStaticDouble(this.atomicMove.heading) + " dist=" + LoudAndProud.printStaticDouble(this.distanceToScanner) + " bear=" + LoudAndProud.printStaticDouble(this.bearingToScanner) + " pos=" + this.pos.toString() + " power=" + LoudAndProud.printStaticDouble(this.power) + " turnRate=" + LoudAndProud.printStaticDouble(this.atomicMove.turnRate) + "deg/turn accRate=" + LoudAndProud.printStaticDouble(this.atomicMove.accelerationRate);
    }

    public String toCSVHead() {
        return "t,name,v,head, dist,bear,posx,posy,power,turnRate,accRate,";
    }

    public String toCSV() {
        return this.scanTime + ",'" + this.botName + "'," + "," + LoudAndProud.printStaticDouble(this.atomicMove.velocity) + "," + LoudAndProud.printStaticDouble(this.atomicMove.heading) + "," + LoudAndProud.printStaticDouble(this.distanceToScanner) + "," + LoudAndProud.printStaticDouble(this.bearingToScanner) + "," + this.pos.x + "," + this.pos.y + "," + LoudAndProud.printStaticDouble(this.power) + "," + LoudAndProud.printStaticDouble(this.atomicMove.turnRate) + "," + LoudAndProud.printStaticDouble(this.atomicMove.accelerationRate);
    }
}

