/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import morbid.FieldAwareObject;
import morbid.IPotentialManager;
import morbid.IRobotController;

class PotentialManager
extends FieldAwareObject
implements IPotentialManager {
    private final Map m_points = new TreeMap();
    private static final boolean DEBUG = false;

    public void update() {
        Iterator i = this.m_points.values().iterator();
        while (i.hasNext()) {
            IPotentialManager.IForcePoint point = (IPotentialManager.IForcePoint)i.next();
            if (point.isActive()) continue;
            i.remove();
        }
    }

    public IPotentialManager.IForcePoint addForcePoint(IPotentialManager.IForcePoint point) {
        this.m_points.put(point.getID(), point);
        return point;
    }

    public IPotentialManager.IForcePoint removeForcePoint(String ID) {
        IPotentialManager.IForcePoint result = (IPotentialManager.IForcePoint)this.m_points.remove(ID);
        return result;
    }

    public IPotentialManager.IForcePoint getForcePoint(String ID) {
        return (IPotentialManager.IForcePoint)this.m_points.get(ID);
    }

    public IPotentialManager.IForcePoint[] getActiveForcePoints() {
        return this.m_points.values().toArray(new IPotentialManager.IForcePoint[this.m_points.size()]);
    }

    public double[] getTotalActiveForce(double x, double y) {
        double[] result = new double[2];
        double[] f = new double[2];
        int p = 0;
        Iterator i = this.m_points.values().iterator();
        while (i.hasNext()) {
            IPotentialManager.IForcePoint point = (IPotentialManager.IForcePoint)i.next();
            if (point.isActive()) {
                point.getForce(f, x, y);
                result[0] = result[0] + f[0];
                result[1] = result[1] + f[1];
            }
            ++p;
        }
        return result;
    }

    public double[] getTotalActiveForce(double[] xy) {
        return this.getTotalActiveForce(xy[0], xy[1]);
    }

    PotentialManager(IRobotController controller) {
        super(controller);
    }
}

