/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import morbid.EnemyFireDetectedEvent;
import morbid.IBulletObject;
import morbid.IEnemyAnalyzer;
import morbid.IEnemyBulletManager;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.IStatsManager;
import morbid.IWeaponManager;
import morbid.Utils;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Event;
import robocode.HitByBulletEvent;

class StatsManager
implements IStatsManager {
    private IRobotController m_controller;
    private AdvancedRobot m_robot;
    private final DistanceComparator m_distanceComparator;
    private double m_size;
    private int m_maxGunCooloffTime;
    private double m_battleFieldWidth;
    private double m_battleFieldHeight;
    private final Set m_knownIDs;
    private String[] m_knownIDs_cache;
    private final Map m_items;
    private int m_others = -1;
    private final Map m_lastEnemyAnalysisTimes;
    private final List m_roundStats = new ArrayList();
    private static final int ENEMY_COUNT_FIRE_DETECTION_THRESHOLD = 2;
    private static final double ENEMY_DISTANCE_FIRE_DETECTION_THRESHOLD = 300.0;
    private static final long MAX_UPDATE_AGE = 50L;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_BULLET_BACKTRACING = false;

    public void update() {
        int e;
        long time = this.m_robot.getTime();
        IRobotPositionManager robotPositionManager = this.m_controller.getRobotPositionManager();
        Stats roundStats = this.getCurrentRoundStats();
        int knownAliveEnemyCount = robotPositionManager.getKnownAliveObjectCount();
        IRobotPositionManager.ITrackedRobot[] trackedEnemies = null;
        if (knownAliveEnemyCount > 0) {
            if (knownAliveEnemyCount <= 2) {
                trackedEnemies = robotPositionManager.getKnownAliveObjects();
            } else {
                this.m_distanceComparator.setXY(this.m_robot.getX(), this.m_robot.getY());
                TreeSet<IRobotPositionManager.ITrackedRobot> selectedEnemies = new TreeSet<IRobotPositionManager.ITrackedRobot>(this.m_distanceComparator);
                IRobotPositionManager.ITrackedRobot[] enemies = robotPositionManager.getKnownAliveObjects();
                e = 0;
                while (e < enemies.length) {
                    double distance = Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), enemies[e].getX(), enemies[e].getY());
                    if (distance < 300.0) {
                        selectedEnemies.add(enemies[e]);
                    }
                    ++e;
                }
                IRobotPositionManager.ITrackedRobot selected = this.m_controller.getEnemySelectionStrategy().selectEnemy();
                selectedEnemies.add(selected);
                if (selectedEnemies.size() <= 2) {
                    trackedEnemies = selectedEnemies.toArray(new IRobotPositionManager.ITrackedRobot[selectedEnemies.size()]);
                } else {
                    trackedEnemies = new IRobotPositionManager.ITrackedRobot[2];
                    boolean selectedIncluded = false;
                    Iterator i = selectedEnemies.iterator();
                    int e2 = 0;
                    while (e2 < trackedEnemies.length) {
                        trackedEnemies[e2] = (IRobotPositionManager.ITrackedRobot)i.next();
                        if (!selectedIncluded) {
                            selectedIncluded = trackedEnemies[e2] == selected;
                        }
                        ++e2;
                    }
                    if (!selectedIncluded) {
                        trackedEnemies[trackedEnemies.length - 1] = selected;
                    }
                }
            }
        }
        if (trackedEnemies != null && trackedEnemies.length > 0) {
            IEnemyBulletManager enemyBulletManager = this.m_controller.getEnemyBulletManager();
            IEnemyAnalyzer enemyAnalyzer = this.m_controller.getEnemyAnalyzer();
            e = 0;
            while (e < trackedEnemies.length) {
                IRobotPositionManager.ITrackedRobot source = trackedEnemies[e];
                IEnemyAnalyzer.EnemyFireGuess[] enemyFire = enemyAnalyzer.guessEnemyFireFacts(source, this.getLastEnemyAnalysisTime(source));
                if (enemyFire != null) {
                    IRobotPositionManager.ITrackedRobot target = robotPositionManager.getSelf();
                    int f = 0;
                    while (f < enemyFire.length) {
                        IBulletObject.IBullet guessedBullet = enemyBulletManager.addBullet(source.getID(), target.getID(), enemyFire[f].m_fireTime, enemyFire[f].m_bulletX, enemyFire[f].m_bulletY, enemyFire[f].m_bulletHeading, enemyFire[f].m_bulletPower, enemyFire[f].m_collateral);
                        this.addEnemyFireFact(roundStats, enemyFire[f].m_fireTime, guessedBullet, source, target);
                        ++f;
                    }
                }
                this.setLastEnemyAnalysisTime(source, time + 1L);
                ++e;
            }
        }
        List eventQueue = this.m_controller.getEventQueue();
        int e3 = 0;
        int queueLength = eventQueue.size();
        while (e3 < queueLength) {
            Event _event = (Event)eventQueue.get(e3);
            if (_event instanceof HitByBulletEvent) {
                this.addEnemyHitFact(roundStats, time, (HitByBulletEvent)_event);
            }
            ++e3;
        }
        String robotSourceID = this.m_robot.getName();
        Iterator i = roundStats.getFireFacts(robotSourceID).iterator();
        while (i.hasNext()) {
            FireFact fireFact = (FireFact)i.next();
            if (fireFact.getHitFact() != null) continue;
            IBulletObject.IBullet bullet = fireFact.getBullet();
            HitFact hitFact = null;
            if (robotPositionManager.isKnownDead(bullet.getTargetID())) {
                hitFact = new HitFact(time, robotSourceID, 4);
            } else {
                String victimID = bullet.getVictimID();
                if (victimID != null) {
                    hitFact = victimID.equals(bullet.getTargetID()) ? new HitFact(time, robotSourceID, 3) : new HitFact(time, robotSourceID, 2);
                } else if (!bullet.isActive()) {
                    hitFact = new HitFact(time, robotSourceID, 1);
                } else {
                    double heading_to_enemy;
                    IRobotPositionManager.ITrackedRobot target = fireFact.m_target;
                    if (time - target.getUpdateTime() < 50L && Math.abs(Utils.deltaPhi(heading_to_enemy = Utils.relativeHeading(bullet.getX(), bullet.getY(), target.getX(), target.getY()), bullet.getHeadingRadians())) > 1.6022122533307945) {
                        hitFact = new HitFact(time, robotSourceID, 1);
                    }
                }
            }
            if (hitFact == null) continue;
            fireFact.setHitFact(hitFact);
            hitFact.setFireFact(fireFact);
            this.addRobotHitFact(roundStats, bullet.getTargetID(), hitFact);
        }
    }

    public void act() {
        long time = this.m_robot.getTime();
        Stats roundStats = this.getCurrentRoundStats();
        IWeaponManager weaponManager = this.m_controller.getWeaponManager();
        Bullet firedBullet = weaponManager.getFiredBullet();
        if (firedBullet != null) {
            this.addRobotFireFact(roundStats, time, firedBullet, this.m_controller.getWeaponStrategy().getFireCollateral(), this.m_controller.getEnemySelectionStrategy().selectEnemy());
        }
    }

    public void roundStart(IRobotController controller, int round) {
        this.m_controller = controller;
        this.m_robot = controller.getRobot();
        this.m_lastEnemyAnalysisTimes.clear();
        if (this.m_others < 0) {
            this.m_others = this.m_robot.getOthers();
            this.m_size = Math.ceil(0.5 * Utils.relativeDistance(0.0, 0.0, this.m_robot.getWidth(), this.m_robot.getHeight()));
            double maxGunHeat = Utils.bulletPowerToGunHeat(3.0);
            this.m_maxGunCooloffTime = (int)Math.ceil(maxGunHeat / this.m_robot.getGunCoolingRate());
            this.m_battleFieldWidth = this.m_robot.getBattleFieldWidth();
            this.m_battleFieldHeight = this.m_robot.getBattleFieldHeight();
        }
        if (round >= this.m_roundStats.size()) {
            this.m_roundStats.add(new Stats());
        }
    }

    public int getCurrentRound() {
        return this.m_roundStats.size() - 1;
    }

    public void roundEnd() {
    }

    public IStatsManager.IStats getStats(int round) {
        return this.getRoundStats(round);
    }

    public IStatsManager.IStats getCurrentStats() {
        return this.getCurrentRoundStats();
    }

    public IStatsManager.IStats getStats(IRobotPositionManager.ITrackedRobot enemy, int roundIndex) {
        if (roundIndex < this.m_roundStats.size()) {
            return (IStatsManager.IStats)this.m_roundStats.get(roundIndex);
        }
        return null;
    }

    public IStatsManager.IStats getStats(IRobotPositionManager.ITrackedRobot enemy, int roundIndex, long startTime) {
        if (roundIndex < this.m_roundStats.size()) {
            Stats round = (Stats)this.m_roundStats.get(roundIndex);
            return new Stats();
        }
        return null;
    }

    public String[] getAllKnownObjectIDs() {
        if (this.m_knownIDs_cache == null) {
            this.m_knownIDs_cache = this.m_knownIDs.toArray(new String[this.m_knownIDs.size()]);
        }
        return this.m_knownIDs_cache;
    }

    public void addObjectID(String ID) {
        if (ID != null) {
            this.m_knownIDs_cache = null;
            this.m_knownIDs.add(ID);
        }
    }

    public IStatsManager.IHitFact getLastEnemyHit() {
        Stats stats = this.getCurrentRoundStats();
        return stats.getLatestHitFact(this.m_robot.getName());
    }

    public long getLastEnemyFireTime(String ID) {
        Stats stats = this.getCurrentRoundStats();
        IStatsManager.IFireFact fact = stats.getLatestFireFact(ID, this.m_robot.getName());
        return fact != null ? fact.getFireTime() : -1L;
    }

    public double getLastEnemyBulletPower(String ID) {
        Stats stats = this.getCurrentRoundStats();
        IStatsManager.IFireFact fact = stats.getLatestFireFact(ID, this.m_robot.getName());
        return fact != null ? fact.getBullet().getPower() : -1.0;
    }

    public void putItem(String key, Object item) {
        this.m_items.put(key, item);
    }

    public Object getItem(String key) {
        return this.m_items.get(key);
    }

    public void putEnemyItem(String ID, String key, Object item) {
        HashMap<String, Object> enemyItems = (HashMap<String, Object>)this.getItem(ID);
        if (enemyItems == null) {
            enemyItems = new HashMap<String, Object>();
            this.putItem(ID, enemyItems);
        }
        enemyItems.put(key, item);
    }

    public Object getEnemyItem(String ID, String key) {
        Map enemyItems = (Map)this.getItem(ID);
        return enemyItems == null ? null : enemyItems.get(key);
    }

    public String toString() {
        return this.getClass().getName() + '@' + this.m_robot.getTime();
    }

    StatsManager() {
        this.m_lastEnemyAnalysisTimes = new HashMap();
        this.m_distanceComparator = new DistanceComparator();
        this.m_knownIDs = new HashSet();
        this.m_items = new HashMap();
    }

    private void addRobotFireFact(Stats roundStats, long fireTime, Bullet bullet, Object collateral, IRobotPositionManager.ITrackedRobot target) {
        if (bullet != null && target != null) {
            IBulletObject.DBullet dbullet = new IBulletObject.DBullet(bullet, target.getID(), collateral);
            FireFact fact = new FireFact(fireTime, dbullet, target);
            roundStats.addFact(this.m_robot.getName(), fact);
        }
    }

    private void addRobotHitFact(Stats roundStats, String targetID, HitFact fact) {
        roundStats.addFact(targetID, fact);
    }

    private void addEnemyFireFact(Stats roundStats, long fireTime, IBulletObject.IBullet bullet, IRobotPositionManager.ITrackedRobot source, IRobotPositionManager.ITrackedRobot target) {
        if (source != null && bullet != null && target != null) {
            FireFact fact = new FireFact(fireTime, bullet, target);
            roundStats.addFact(source.getID(), fact);
            this.m_controller.broadcastEvent(new EnemyFireDetectedEvent(fact));
        }
    }

    public void addEnemyHitFact(Stats roundStats, long hitTime, HitByBulletEvent event) {
        Bullet bullet = event.getBullet();
        String sourceID = event.getName();
        HitFact hitFact = new HitFact(hitTime, sourceID, 3);
        roundStats.addFact(sourceID, hitFact);
        IRobotPositionManager.ITrackedRobot source = this.m_controller.getRobotPositionManager().getKnownAliveObject(hitFact.getSourceID());
        if (source != null) {
            long minSourcePointTime;
            IRobotPositionManager.ITrackedRobotTimeSeries sourceSeries = source.getRobotTimeSeries();
            long minFireTime = hitTime - (long)Math.ceil(Utils.relativeDistance(0.0, 0.0, this.m_battleFieldWidth, this.m_battleFieldHeight) / bullet.getVelocity());
            if (minFireTime < (minSourcePointTime = sourceSeries.getEarliestRobotPoint().getUpdateTime())) {
                minFireTime = minSourcePointTime;
            }
            double[] bulletXY = new double[]{bullet.getX(), bullet.getY()};
            double reverseBulletHeading = Utils.normalizePlus(bullet.getHeadingRadians(), Math.PI);
            double bulletVelocity = bullet.getVelocity();
            SortedSet fireFacts = ((Stats)this.getCurrentStats()).getFireFacts(hitFact.getSourceID());
            boolean matchFound = false;
            long fireTime = hitTime;
            block0: while (fireTime >= minFireTime) {
                SortedSet<FireFact> nearbyFireFacts;
                Utils.interpolate(bulletXY, bulletXY[0], bulletXY[1], reverseBulletHeading, bulletVelocity, 1.0);
                IRobotPositionManager.IUpdatedRobot point = sourceSeries.getRobotPointByTime(fireTime);
                if (point.getUpdateTime() == fireTime && Utils.relativeDistance(bulletXY, point.getXY()) < 2.0 * this.m_size && !fireFacts.isEmpty() && !(nearbyFireFacts = fireFacts.subSet(new FireFact(fireTime - (long)(this.m_maxGunCooloffTime / 2)), new FireFact(fireTime + (long)(this.m_maxGunCooloffTime / 2)))).isEmpty()) {
                    Iterator i = nearbyFireFacts.iterator();
                    while (i.hasNext()) {
                        FireFact fireFact = (FireFact)i.next();
                        if (fireFact.getHitFact() != null || Math.abs(fireFact.getFireTime() - fireTime) > (long)(this.m_maxGunCooloffTime / 4)) continue;
                        fireFact.setHitFact(hitFact);
                        hitFact.setFireFact(fireFact);
                        matchFound = true;
                        break block0;
                    }
                }
                --fireTime;
            }
        }
    }

    private Stats getCurrentRoundStats() {
        return this.getRoundStats(this.m_roundStats.size() - 1);
    }

    private Stats getRoundStats(int round) {
        return (Stats)this.m_roundStats.get(round);
    }

    private long getLastEnemyAnalysisTime(IRobotPositionManager.ITrackedRobot enemy) {
        Long _time = (Long)this.m_lastEnemyAnalysisTimes.get(enemy.getID());
        return _time == null ? enemy.getRobotTimeSeries().getEarliestRobotPoint().getUpdateTime() : _time.longValue();
    }

    private void setLastEnemyAnalysisTime(IRobotPositionManager.ITrackedRobot enemy, long time) {
        this.m_lastEnemyAnalysisTimes.put(enemy.getID(), new Long(time));
    }

    private static final class Stats
    implements IStatsManager.IStats {
        final Map m_fireFacts = new HashMap(7);
        final Map m_hitFacts = new HashMap(7);
        private static final IStatsManager.IFireFact[] EMPTY_IFIREFACT_ARRAY = new IStatsManager.IFireFact[0];
        private static final IStatsManager.IHitFact[] EMPTY_IHITFACT_ARRAY = new IStatsManager.IHitFact[0];

        public IStatsManager.IFireFact[] getFireFacts(String sourceID, String targetID) {
            return this.getFireFacts(sourceID, targetID, 0L);
        }

        public IStatsManager.IHitFact[] getHitFacts(String sourceID, String targetID) {
            return this.getHitFacts(sourceID, targetID, 0L);
        }

        public IStatsManager.IFireFact[] getFireFacts(String sourceID, String targetID, long startTime) {
            if (!this.m_fireFacts.containsKey(sourceID)) {
                return EMPTY_IFIREFACT_ARRAY;
            }
            SortedSet facts = this.getFireFacts(sourceID);
            if (facts.isEmpty()) {
                return EMPTY_IFIREFACT_ARRAY;
            }
            ArrayList<FireFact> _result = new ArrayList<FireFact>(facts.size());
            Iterator i = facts.iterator();
            while (i.hasNext()) {
                FireFact fact = (FireFact)i.next();
                if (fact.getFireTime() < startTime || !targetID.equals(fact.getBullet().getTargetID())) continue;
                _result.add(fact);
            }
            return _result.toArray(new IStatsManager.IFireFact[_result.size()]);
        }

        public IStatsManager.IHitFact[] getHitFacts(String sourceID, String targetID, long startTime) {
            if (!this.m_hitFacts.containsKey(targetID)) {
                return EMPTY_IHITFACT_ARRAY;
            }
            SortedSet facts = this.getHitFacts(targetID);
            if (facts.isEmpty()) {
                return EMPTY_IHITFACT_ARRAY;
            }
            ArrayList<HitFact> _result = new ArrayList<HitFact>(facts.size());
            Iterator i = facts.iterator();
            while (i.hasNext()) {
                HitFact fact = (HitFact)i.next();
                if (fact.getHitTime() < startTime || !sourceID.equals(fact.getSourceID())) continue;
                _result.add(fact);
            }
            return _result.toArray(new IStatsManager.IHitFact[_result.size()]);
        }

        Stats() {
        }

        IStatsManager.IFireFact getLatestFireFact(String sourceID, String targetID) {
            if (!this.m_fireFacts.containsKey(sourceID)) {
                return null;
            }
            SortedSet facts = this.getFireFacts(sourceID);
            if (facts.isEmpty()) {
                return null;
            }
            FireFact last = (FireFact)facts.last();
            if (targetID.equals(last.getBullet().getTargetID())) {
                return last;
            }
            SortedSet<FireFact> subset = facts.headSet(last);
            while (!subset.isEmpty()) {
                last = subset.last();
                if (!targetID.equals(last.getBullet().getTargetID())) continue;
                return last;
            }
            return null;
        }

        IStatsManager.IHitFact getLatestHitFact(String sourceID, String targetID) {
            if (!this.m_hitFacts.containsKey(targetID)) {
                return null;
            }
            SortedSet facts = this.getHitFacts(targetID);
            if (facts.isEmpty()) {
                return null;
            }
            HitFact last = (HitFact)facts.last();
            if (sourceID.equals(last.getSourceID())) {
                return last;
            }
            SortedSet<HitFact> subset = facts.headSet(last);
            while (!subset.isEmpty()) {
                last = subset.last();
                if (!sourceID.equals(last.getSourceID())) continue;
                return last;
            }
            return null;
        }

        IStatsManager.IHitFact getLatestHitFact(String targetID) {
            if (!this.m_hitFacts.containsKey(targetID)) {
                return null;
            }
            SortedSet facts = this.getHitFacts(targetID);
            if (facts.isEmpty()) {
                return null;
            }
            return (HitFact)facts.last();
        }

        SortedSet getFireFacts(String sourceID) {
            TreeSet facts = (TreeSet)this.m_fireFacts.get(sourceID);
            if (facts == null) {
                facts = new TreeSet(new FireFact.FireFactComparator());
                this.m_fireFacts.put(sourceID, facts);
            }
            return facts;
        }

        SortedSet getHitFacts(String targetID) {
            TreeSet facts = (TreeSet)this.m_hitFacts.get(targetID);
            if (facts == null) {
                facts = new TreeSet(new HitFact.HitFactComparator());
                this.m_hitFacts.put(targetID, facts);
            }
            return facts;
        }

        void addFact(String sourceID, FireFact fact) {
            this.getFireFacts(sourceID).add(fact);
        }

        void addFact(String targetID, HitFact fact) {
            this.getHitFacts(targetID).add(fact);
        }
    }

    private static final class HitFact
    implements IStatsManager.IHitFact {
        private final String m_sourceID;
        private final long m_hitTime;
        private final int m_hitStatus;
        private IStatsManager.IFireFact m_fireFact;

        public final String getSourceID() {
            return this.m_fireFact != null ? this.m_fireFact.getBullet().getSourceID() : this.m_sourceID;
        }

        public final long getHitTime() {
            return this.m_hitTime;
        }

        public int getHitStatus() {
            return this.m_hitStatus;
        }

        public IStatsManager.IFireFact getFireFact() {
            return this.m_fireFact;
        }

        HitFact(long hitTime, String sourceID, int hitStatus) {
            this.m_sourceID = sourceID;
            this.m_hitTime = hitTime;
            this.m_hitStatus = hitStatus;
        }

        void setFireFact(IStatsManager.IFireFact fact) {
            this.m_fireFact = fact;
        }

        static final class HitFactComparator
        implements Comparator {
            HitFactComparator() {
            }

            public int compare(Object o1, Object o2) {
                long ht2;
                long ht1 = ((HitFact)o1).m_hitTime;
                return ht1 < (ht2 = ((HitFact)o2).m_hitTime) ? -1 : (ht1 > ht2 ? 1 : 0);
            }
        }
    }

    private static final class FireFact
    implements IStatsManager.IFireFact {
        private final long m_fireTime;
        private final IBulletObject.IBullet m_bullet;
        private final IRobotPositionManager.ITrackedRobot m_target;
        private IStatsManager.IHitFact m_hitFact;

        public final long getFireTime() {
            return this.m_fireTime;
        }

        public final IBulletObject.IBullet getBullet() {
            return this.m_bullet;
        }

        public final IStatsManager.IHitFact getHitFact() {
            return this.m_hitFact;
        }

        FireFact(long fireTime, IBulletObject.IBullet bullet, IRobotPositionManager.ITrackedRobot target) {
            this.m_fireTime = fireTime;
            this.m_bullet = bullet;
            this.m_target = target;
        }

        FireFact(long fireTime) {
            this.m_fireTime = fireTime;
            this.m_bullet = null;
            this.m_target = null;
        }

        void setHitFact(IStatsManager.IHitFact fact) {
            this.m_hitFact = fact;
        }

        static final class FireFactComparator
        implements Comparator {
            FireFactComparator() {
            }

            public int compare(Object o1, Object o2) {
                long ft2;
                long ft1 = ((FireFact)o1).m_fireTime;
                return ft1 < (ft2 = ((FireFact)o2).m_fireTime) ? -1 : (ft1 > ft2 ? 1 : 0);
            }
        }
    }

    static final class DistanceComparator
    implements Comparator {
        private double[] m_xy = new double[2];

        DistanceComparator() {
        }

        public int compare(Object o1, Object o2) {
            double r2;
            double r1 = Utils.relativeDistance(this.m_xy, ((IRobotPositionManager.IUpdatedRobot)o1).getXY());
            return r1 < (r2 = Utils.relativeDistance(this.m_xy, ((IRobotPositionManager.IUpdatedRobot)o2).getXY())) ? -1 : (r1 > r2 ? 1 : 0);
        }

        void setXY(double x, double y) {
            this.m_xy[0] = x;
            this.m_xy[1] = y;
        }
    }
}

