/*
 * Decompiled with CFR 0.152.
 */
package zh;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import zh.Enemy;
import zh.logging.MyLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnemyManager {
    private static MyLogger logger = MyLogger.getLogger(EnemyManager.class.getName());
    private HashMap<String, Enemy> enemyMap = new HashMap();
    private static final EnemyManager instance;

    private EnemyManager() {
    }

    public static final EnemyManager getInstance() {
        return instance;
    }

    public void processEvent(ScannedRobotEvent scanned, Point2D enemyLocation) {
        Enemy enemy = null;
        if (this.enemyMap.containsKey(scanned.getName())) {
            logger.log("EXISTING Enemy: " + scanned.getName());
            enemy = this.enemyMap.get(scanned.getName());
            enemy.updateData(scanned, enemyLocation);
        } else {
            logger.log("NEW Enemy: " + scanned.getName());
            enemy = new Enemy(scanned, enemyLocation);
            this.enemyMap.put(scanned.getName(), enemy);
        }
    }

    public void processEvent(RobotDeathEvent killed) {
        if (this.enemyMap.containsKey(killed.getName())) {
            this.enemyMap.remove(killed.getName());
        }
    }

    public void processEvent(DeathEvent event) {
        this.enemyMap.clear();
    }

    public void processEvent(WinEvent event) {
        this.enemyMap.clear();
    }

    public void processEvent(BulletMissedEvent event) {
    }

    public void processEvent(BulletHitEvent event) {
        Enemy enemy;
        if (this.enemyMap.containsKey(event.getName()) && (enemy = this.enemyMap.get(event.getName())) != null) {
            enemy.bulletHitMe();
        }
    }

    public boolean hasEnemy() {
        return this.enemyMap.keySet().size() > 0;
    }

    public int getNumberOfKnownEnemies() {
        return this.enemyMap.keySet().size();
    }

    public Collection<Enemy> getAllEnemies() {
        return Collections.unmodifiableCollection(this.enemyMap.values());
    }

    public Enemy getClosestEnemy() {
        Enemy closestEnemy = null;
        for (String name : this.enemyMap.keySet()) {
            Enemy enemy = this.enemyMap.get(name);
            if (closestEnemy != null && !(enemy.getDistance() < closestEnemy.getDistance())) continue;
            closestEnemy = enemy;
        }
        return closestEnemy;
    }

    public Enemy getEnemy(String name) {
        return this.enemyMap.get(name);
    }

    static {
        logger.setEnabled(false);
        instance = new EnemyManager();
    }
}

