/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.KDTree;

import java.util.Arrays;
import java.util.Iterator;
import rdt.Wraith.KDTree.BinaryHeap;
import rdt.Wraith.KDTree.DistanceFunction;
import rdt.Wraith.KDTree.IntervalHeap;
import rdt.Wraith.KDTree.KdNode;
import rdt.Wraith.KDTree.KdTree;
import rdt.Wraith.KDTree.MinHeap;

public class NearestNeighborIterator<T>
implements Iterator<T>,
Iterable<T> {
    private DistanceFunction distanceFunction;
    private double[] searchPoint;
    private MinHeap<KdNode<T>> pendingPaths;
    private IntervalHeap<T> evaluatedPoints;
    private int pointsRemaining;
    private double lastDistanceReturned;

    protected NearestNeighborIterator(KdNode<T> treeRoot, double[] searchPoint, int maxPointsReturned, DistanceFunction distanceFunction) {
        this.searchPoint = Arrays.copyOf(searchPoint, searchPoint.length);
        this.pointsRemaining = Math.min(maxPointsReturned, treeRoot.size());
        this.distanceFunction = distanceFunction;
        this.pendingPaths = new BinaryHeap.Min<KdNode<T>>();
        this.pendingPaths.offer(0.0, treeRoot);
        this.evaluatedPoints = new IntervalHeap();
    }

    @Override
    public boolean hasNext() {
        return this.pointsRemaining > 0;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("NearestNeighborIterator has reached end!");
        }
        while (this.pendingPaths.size() > 0 && (this.evaluatedPoints.size() == 0 || this.pendingPaths.getMinKey() < this.evaluatedPoints.getMinKey())) {
            KdTree.nearestNeighborSearchStep(this.pendingPaths, this.evaluatedPoints, this.pointsRemaining, this.distanceFunction, this.searchPoint);
        }
        --this.pointsRemaining;
        this.lastDistanceReturned = this.evaluatedPoints.getMinKey();
        T value = this.evaluatedPoints.getMin();
        this.evaluatedPoints.removeMin();
        return value;
    }

    public double distance() {
        return this.lastDistanceReturned;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

