/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Targeting;

import rdt.Wraith.EscapeEnvelope.EscapeEnvelope;
import rdt.Wraith.Guns.EnemyGunManager;
import rdt.Wraith.Guns.FriendlyGunManager;
import rdt.Wraith.Guns.IGunManager;
import rdt.Wraith.IRobot;
import rdt.Wraith.RobotSnapshots.FrequencyValue;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Waves.IWaveManager;

public class Target {
    public boolean Valid;
    public boolean Alive;
    public boolean Disabled;
    public long LastUpdatedTick;
    public long LastTickFired = Long.MIN_VALUE;
    public double LastFiredBulletFirepower = 0.0;
    public long NextTickCanFireAgain = 0L;
    public long MaxSafePredictedTick = 0L;
    public long LastTickTargetHitUs = Long.MIN_VALUE;
    public double LastEnergyGainedFromHittingUs = 0.0;
    public long LastTickWeHitTarget = Long.MIN_VALUE;
    public double LastEnergyLostFromUsHittingTarget = 0.0;
    public FrequencyValue DirectionChangeFrequency2 = new FrequencyValue(2);
    public FrequencyValue DirectionChangeFrequency3 = new FrequencyValue(3);
    public FrequencyValue DirectionChangeFrequency5 = new FrequencyValue(5);
    public FrequencyValue DirectionChangeFrequency9 = new FrequencyValue(9);
    public RobotSnapshots RobotSnapshots;
    public IGunManager GunsFiredFromTarget;
    public IGunManager GunsFiredAtTarget;
    public EscapeEnvelope EscapeEnvelope;
    private IRobot _robot;

    public Target(String targetName, IRobot robot, IWaveManager friendlyWaveManager, IWaveManager enemyWaveManager, IStats stats) {
        this._robot = robot;
        this.EscapeEnvelope = new EscapeEnvelope(robot, this);
        this.RobotSnapshots = new RobotSnapshots();
        this.GunsFiredFromTarget = new EnemyGunManager("Self", robot, robot.GetRobotSnapshots(), enemyWaveManager, stats);
        this.GunsFiredAtTarget = new FriendlyGunManager("Target", robot, this.RobotSnapshots, friendlyWaveManager, stats);
        this.OnRoundStart();
    }

    public void Invalidate() {
        this.Alive = false;
        this.Valid = false;
        this.Disabled = false;
    }

    public void OnRoundStart() {
        this.RobotSnapshots.OnRoundStart(this._robot.getRoundNum());
        double InitialHeat = 3.0;
        this.LastUpdatedTick = -1L;
        this.MaxSafePredictedTick = -1L;
        this.LastTickFired = Long.MIN_VALUE;
        this.NextTickCanFireAgain = (long)Math.ceil(InitialHeat / 0.1);
        this.LastTickTargetHitUs = Long.MIN_VALUE;
        this.LastTickWeHitTarget = Long.MIN_VALUE;
        this.Valid = false;
        this.DirectionChangeFrequency2.Reset();
        this.DirectionChangeFrequency3.Reset();
        this.DirectionChangeFrequency5.Reset();
        this.DirectionChangeFrequency9.Reset();
    }

    public long GetSafePredictedTick(long tick) {
        return Math.min(this.MaxSafePredictedTick, tick);
    }
}

