/*
 * Decompiled with CFR 0.152.
 */
package MyRobots;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Rival {
    private AdvancedRobot robot;
    private double fire;
    private double lastEnergy;
    private ScannedRobotEvent rival = null;
    private double bearingFromRival = 0.0;
    private int fireCount = 0;

    public Rival(AdvancedRobot robot) {
        this.robot = robot;
        this.fireCount = 0;
    }

    public void updateRivalOnScannedRobot(ScannedRobotEvent e) {
        this.rival = e;
        this.bearingFromRival = Utils.normalRelativeAngleDegrees((double)(this.robot.getHeading() + this.rival.getBearing() - this.rival.getHeading() + 180.0));
        this.fire = this.lastEnergy - e.getEnergy();
        if (this.fire < 0.0 || 3.0 < this.fire) {
            this.fire = 0.0;
        }
        if (this.fire != 0.0) {
            ++this.fireCount;
        }
        this.lastEnergy = e.getEnergy();
    }

    public void updateRivalOnBulletHit(BulletHitEvent e) {
        this.lastEnergy = e.getEnergy();
    }

    public void updateRivalOnHitByBullet(HitByBulletEvent e) {
        this.lastEnergy += 3.0 * e.getPower();
    }

    public double getX() {
        double relativeX = this.rival.getDistance() * Math.sin(this.robot.getHeading() + this.rival.getBearing());
        return relativeX;
    }

    public double getY() {
        double relativeY = this.rival.getDistance() * Math.cos(this.robot.getHeading() + this.rival.getEnergy());
        return relativeY;
    }

    public double getAbsoluteX() {
        double absoluteX = this.robot.getX() + this.getX();
        return absoluteX;
    }

    public double getAbsoluteY() {
        double absoluteY = this.robot.getY() + this.getY();
        return absoluteY;
    }

    public double getAbsoluteBearing() {
        double r = this.robot.getHeading() + this.rival.getBearing();
        if ((r %= 360.0) < 0.0) {
            r = 360.0 + r;
        }
        return r;
    }

    public double getBearingFromRival() {
        return this.bearingFromRival;
    }

    public double getL() {
        return this.rival.getDistance();
    }

    public double getFire() {
        return this.fire;
    }

    public double getCloseSpeed() {
        double closeSpeed = this.rival.getVelocity() * Math.cos(Math.toRadians(this.bearingFromRival));
        return closeSpeed;
    }

    public double getSwingSpeed() {
        double swingSpeed = this.rival.getVelocity() * Math.sin(Math.toRadians(this.bearingFromRival));
        return swingSpeed;
    }

    public int getFireCount() {
        return this.fireCount;
    }

    public double getFireRate() {
        return (double)this.fireCount / (double)this.robot.getTime();
    }

    public double getAngularVelocity() {
        double angularVelocity = this.getSwingSpeed() / this.rival.getDistance();
        return Math.toDegrees(angularVelocity);
    }
}

