/*
 * Decompiled with CFR 0.152.
 */
package de.erdega.robocode.util;

import java.io.Serializable;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.util.Utils;

public class Vector
implements Serializable {
    private static final long serialVersionUID = -7912452376637304003L;
    private double _x;
    private double _y;
    private double _length;
    private double _phi;

    public Vector() {
        this.setXY(0.0, 0.0);
    }

    public Vector(double x, double y) {
        this.setXY(x, y);
    }

    public Vector(Vector v) {
        this._x = v._x;
        this._y = v._y;
        this._length = v._length;
        this._phi = v._phi;
    }

    private void setXY(double x, double y) {
        this._x = x;
        this._y = y;
        this.calcPolar();
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    private void setPolar(double length, double phi) {
        this._length = length;
        this._phi = Utils.normalRelativeAngle((double)phi);
        this.calcXY();
        if (this._length < 0.0) {
            this.calcPolar();
        }
    }

    public double getLength() {
        return this._length;
    }

    public double getPhi() {
        return this._phi;
    }

    public double dotProduct(Vector v) {
        return this._x * v._x + this._y * v._y;
    }

    public Vector add(Vector v) {
        return Vector.add(this, v);
    }

    public static Vector add(Vector v1, Vector v2) {
        return new Vector(v1._x + v2._x, v1._y + v2._y);
    }

    public Vector sub(Vector v) {
        return Vector.sub(this, v);
    }

    public static Vector sub(Vector v1, Vector v2) {
        return new Vector(v1._x - v2._x, v1._y - v2._y);
    }

    public Vector scale(double factor) {
        return new Vector(this._x * factor, this._y * factor);
    }

    public static Vector createPolarVector(double length, double phi) {
        Vector v = new Vector();
        v.setPolar(length, phi);
        return v;
    }

    public String toString() {
        return "[" + this._x + "; " + this._y + "] | [" + this._length + "; " + this._phi + "]";
    }

    private void calcXY() {
        this._x = Math.sin(this._phi) * this._length;
        this._y = Math.cos(this._phi) * this._length;
    }

    private void calcPolar() {
        this._length = Math.sqrt(this.dotProduct(this));
        if (this._length > 1.0E-20) {
            this._phi = Math.acos(this._y / this._length);
            if (this._x < 0.0) {
                this._phi = Math.PI * 2 - this._phi;
            }
        } else {
            this._phi = 0.0;
        }
    }

    public double getAngle(Vector v) {
        double cosAngle = Math.min(1.0, this.dotProduct(v) / this._length / v._length);
        return Math.acos(cosAngle) * Math.signum(this._x * v._y - this._y * v._x);
    }

    public Vector getUnit() {
        return Vector.createPolarVector(1.0, this._phi);
    }

    public static Vector getBattleFieldMiddle(Robot robot) {
        return new Vector(robot.getBattleFieldWidth() / 2.0, robot.getBattleFieldHeight() / 2.0);
    }

    public static Vector getPosition(AdvancedRobot robot) {
        return new Vector(robot.getX(), robot.getY());
    }

    public static Vector getHeading(AdvancedRobot robot) {
        return Vector.createPolarVector(1.0, robot.getHeadingRadians());
    }
}

