/*
 * Decompiled with CFR 0.152.
 */
package gjr;

import gjr.BaseStrategy;
import gjr.Enemy;
import gjr.RobocodeUtils;
import gjr.StrategyRobot;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class EnemiesTrackingStrategy
extends BaseStrategy {
    protected final Map enemies = new HashMap();

    public void onScannedRobot(ScannedRobotEvent e) {
        StrategyRobot robot = this.getRobot();
        String name = e.getName();
        double absoluteBearing = e.getBearingRadians() + robot.getHeadingRadians();
        double distance = e.getDistance();
        Point2D.Double myPosition = new Point2D.Double(robot.getX(), robot.getY());
        Point2D.Double enemyPosition = RobocodeUtils.calculatePosition(absoluteBearing, distance, myPosition);
        double enemyHeadingRadians = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double enemyEnergy = e.getEnergy();
        long time = robot.getTime();
        Object enemyObject = this.enemies.get(name);
        if (enemyObject != null) {
            Enemy enemy = (Enemy)enemyObject;
            EnemiesTrackingStrategy.updateEnemy(enemy, enemyPosition, enemyHeadingRadians, time, enemyVelocity, enemyEnergy);
        } else {
            Enemy enemy = new Enemy(name, enemyPosition.getX(), enemyPosition.getY(), enemyHeadingRadians, enemyVelocity, enemyEnergy, time, true, 1.0);
            this.enemies.put(e.getName(), enemy);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.enemies.remove(e.getName());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double power = e.getPower();
        double damage = RobocodeUtils.calculateBulletDamage(power);
        Object enemyObject = this.enemies.get(e.getName());
        if (enemyObject != null) {
            Enemy enemy = (Enemy)enemyObject;
            enemy.setDanger(enemy.getDanger() + damage);
        }
    }

    protected Enemy getClosestEnemy() {
        StrategyRobot robot = this.getRobot();
        Iterator keys = this.enemies.keySet().iterator();
        Enemy closest = null;
        double closestDistance = Double.POSITIVE_INFINITY;
        while (keys.hasNext()) {
            Enemy enemy = (Enemy)this.enemies.get(keys.next());
            double distance = Point2D.Double.distance(robot.getX(), robot.getY(), enemy.getX(), enemy.getY());
            if (!enemy.isTarget() || !(distance < closestDistance - 200.0)) continue;
            closest = enemy;
            closestDistance = distance;
        }
        return closest;
    }

    protected Enemy getOldestEnemy() {
        StrategyRobot robot = this.getRobot();
        Iterator keys = this.enemies.keySet().iterator();
        Enemy oldest = null;
        while (keys.hasNext()) {
            Enemy enemy = (Enemy)this.enemies.get(keys.next());
            if (!enemy.isTarget()) continue;
            if (oldest == null) {
                oldest = enemy;
                continue;
            }
            if (enemy.getTime() >= oldest.getTime()) continue;
            oldest = enemy;
        }
        if (oldest != null) {
            robot.out.println("oldest is " + oldest.getName());
        }
        return oldest;
    }

    private static void updateEnemy(Enemy enemy, Point2D.Double enemyPosition, double enemyHeadingRadians, long time, double enemyVelocity, double enemyEnergy) {
        enemy.setX(enemyPosition.getX());
        enemy.setY(enemyPosition.getY());
        enemy.setHeadingRadiansChange((enemyHeadingRadians - enemy.getHeadingRadians()) / (double)(time - enemy.getTime()));
        enemy.setHeadingRadians(enemyHeadingRadians);
        enemy.setAcceleration((enemyVelocity - enemy.getVelocity()) / (double)(time - enemy.getTime()));
        enemy.setVelocity(enemyVelocity);
        enemy.setEnergy(enemyEnergy);
        enemy.setTime(time);
    }
}

