/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Constraints;
import pedersen.core.Conversions;
import pedersen.core.Snapshot;
import pedersen.debug.Debug;
import pedersen.divination.CombatWave;
import pedersen.divination.WaveInboundBank;
import pedersen.divination.WaveInboundImpl;
import pedersen.misc.Arena;
import pedersen.misc.ShortestRoute;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.Projection;
import pedersen.physics.SlopeFormula;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.systems.DrivingMethodStandardImpl;
import pedersen.tactics.movement.MovementMethod;

public abstract class MovementMethodBase
implements MovementMethod {
    public static boolean isDebugMode = false;
    private int persistenceId;
    private int timeInUse = 0;
    private int hitTally = 0;
    protected boolean exclusive = false;
    private static double pinAngle = Conversions.degreesToRadians(10.0);
    private static double unpinAngle = Conversions.degreesToRadians(11.0);

    public MovementMethodBase(int newPersistenceId) {
        this.persistenceId = newPersistenceId;
    }

    public void recordTime() {
        ++this.timeInUse;
    }

    public void onHitByBullet(WaveInboundImpl wave) {
        ++this.hitTally;
    }

    public void onEnemyFire(CombatWave wave) {
    }

    public void activate(Snapshot chassis) {
    }

    protected double calculateMagnitude(double force, double distance) {
        double ratio = force / distance;
        return ratio * Math.abs(ratio);
    }

    public StaticPosition getDestination(CombatWave wave, double bearingOffset) {
        return ShortestRoute.getGuessFactorPosition(wave, bearingOffset);
    }

    public boolean isDestinationViable(Snapshot position, StaticPosition destination, long time) {
        boolean isDestinationViable = false;
        List waveList = WaveInboundBank.singleton.getCopyOfWaveList();
        Projection projection = new Projection(position);
        boolean isHit = false;
        long i = 0L;
        while (!isHit && i < 200L && waveList.size() > 0) {
            Color debugColor = !isDebugMode ? null : Color.orange;
            StaticPosition projectedPosition = projection.getStaticPosition();
            long projectedTime = time + i;
            Iterator iterator = waveList.iterator();
            while (iterator.hasNext() && !isHit) {
                CombatWave wave = (CombatWave)iterator.next();
                if (wave.isWaveBeyondRobotPosition(projectedPosition, time + i)) {
                    iterator.remove();
                    continue;
                }
                isHit = wave.doesAnyFiringAngleInterceptRobot(projectedPosition, projectedTime, debugColor);
            }
            if (!isHit) {
                StaticVector movementVector = DrivingMethodStandardImpl.operate(projection, destination);
                projection.setRelativeTargetHeading(movementVector.getHeading());
                projection.setAbsoluteTargetVelocity(movementVector.getVelocity());
                projection.project();
            }
            ++i;
        }
        isDestinationViable = !isHit;
        return isDestinationViable;
    }

    public static double getDistanceRating(StaticPosition position) {
        double distanceRating = 0.0;
        Iterator iterator = TargetBank.singleton.iterator();
        while (iterator.hasNext()) {
            Target target = (Target)iterator.next();
            if (!target.isActive()) continue;
            double distance = position.getDistance(target);
            if (distance < 100.0) {
                distanceRating += 10.0;
            } else if (distance < 200.0) {
                distanceRating += 5.0;
            } else if (distance < 400.0) {
                distanceRating += 2.0;
            } else if (distance < 600.0) {
                distanceRating += 1.0;
            }
            distance *= target.getEnergy();
        }
        return distanceRating;
    }

    public StaticVector getWiggleVector(Snapshot combatant, Snapshot target, long time) {
        StaticVectorImpl vector = null;
        if (target != null) {
            if (combatant.getDistance(target) < 150.0) {
                StaticPosition center = Arena.getCenter();
                double bearingToCombatant = center.getBearing(combatant);
                double bearingToTarget = center.getBearing(target);
                if (center.getDistance(target) < center.getDistance(combatant) && Constraints.isInRange(-pinAngle, StaticHeadingImpl.getRelativeAngle(bearingToTarget, bearingToCombatant), pinAngle)) {
                    SlopeFormula tangent1 = new SlopeFormula(center, target);
                    SlopeFormula tangent2 = new SlopeFormula(center, combatant);
                    SlopeFormula slopeA = new SlopeFormula(center, bearingToTarget - unpinAngle);
                    SlopeFormula slopeB = new SlopeFormula(center, bearingToTarget + unpinAngle);
                    StaticPosition a = slopeA.getPointOfIntercept(tangent1);
                    StaticPosition b = slopeB.getPointOfIntercept(tangent1);
                    vector = combatant.getDistance(a) < combatant.getDistance(b) ? new StaticVectorImpl(combatant.getBearing(slopeA.getPointOfIntercept(tangent2)), 50.0) : new StaticVectorImpl(combatant.getBearing(slopeB.getPointOfIntercept(tangent2)), 50.0);
                } else {
                    vector = new StaticVectorImpl(target.getBearing(combatant), 150.0);
                }
            } else {
                double tangent = StaticHeadingImpl.getTangentAngle(target.getBearing(combatant));
                if (Constraints.isRelativeHeadingToRear(combatant.getRelativeAngle(tangent))) {
                    tangent = StaticHeadingImpl.getOpposedAngle(tangent);
                }
                vector = new StaticVectorImpl(tangent, 0.0);
            }
        }
        return vector;
    }

    public static void onPaint() {
        isDebugMode = true;
    }

    public void debug() {
        if (this.timeInUse == 0) {
            Debug.debug(String.valueOf(this.getClass().getSimpleName()) + " has not been not used.");
        } else if (this.hitTally == 0) {
            Debug.debug(String.valueOf(this.getClass().getSimpleName()) + "has not been hit over " + this.timeInUse + " ticks.");
        } else {
            Debug.debug(String.valueOf(this.getClass().getSimpleName()) + " Hits: " + this.hitTally + ", Time in Use: " + this.timeInUse + ", Average t/h: " + Debug.trim((double)this.timeInUse / (double)this.hitTally));
        }
    }

    public int getPersistenceId() {
        return this.persistenceId;
    }

    public int getTimeInUse() {
        return this.timeInUse;
    }

    public int getHitTally() {
        return this.hitTally;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }
}

