/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile;

import cbot.agile.CU;
import cbot.agile.PrayInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;

public class StorageManager {
    private static AdvancedRobot robot;
    private static boolean IGNORE_DATA;
    private static Hashtable prayHash;

    public static void init(AdvancedRobot _robot) {
        robot = _robot;
    }

    public static Object readCompressedObject(String filename) {
        if (IGNORE_DATA || CU.melee) {
            return null;
        }
        try {
            ZipInputStream zipin = new ZipInputStream(new FileInputStream(robot.getDataFile(filename + ".zip")));
            zipin.getNextEntry();
            ObjectInputStream in = new ObjectInputStream(zipin);
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (FileNotFoundException e) {
            CU.log("StorageManager: File not found");
        }
        catch (IOException e) {
            CU.log("StorageManager: I/O Exception: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            CU.log("StorageManager: Class not found");
            e.printStackTrace();
        }
        catch (Exception e) {
            CU.log("StorageManager: Unexpected error (OK in unit test)");
            e.printStackTrace();
        }
        return null;
    }

    public static void writeObject(Serializable obj, String filename) {
        if (IGNORE_DATA || CU.melee) {
            return;
        }
        boolean ioError = true;
        int count = 0;
        while (ioError && count++ < 10) {
            ioError = false;
            try {
                ZipOutputStream zipout = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(robot.getDataFile(filename + ".zip")));
                zipout.putNextEntry(new ZipEntry(filename));
                ObjectOutputStream out = new ObjectOutputStream(zipout);
                out.writeObject(obj);
                out.flush();
                zipout.closeEntry();
                out.close();
            }
            catch (IOException e) {
                System.out.println("StorageManager: Error writing Object: " + e);
            }
        }
    }

    public static void writeDataToFile() {
        Enumeration enm = prayHash.keys();
        while (enm.hasMoreElements()) {
            String prayName = (String)enm.nextElement();
            PrayInfo pi = (PrayInfo)prayHash.get(prayName);
            StorageManager.writeObject(pi, CU.getPrayFileName(prayName));
        }
    }

    public static void putObject(String prayName, Object key, Object obj) {
        PrayInfo prayInfo = (PrayInfo)prayHash.get(prayName);
        if (prayInfo == null) {
            prayInfo = new PrayInfo();
            prayHash.put(prayName, prayInfo);
        }
        prayInfo.putObject(key, obj);
    }

    public static Object getObject(String prayName, Object key) {
        PrayInfo prayInfo = (PrayInfo)prayHash.get(prayName);
        if (prayInfo == null) {
            try {
                prayInfo = (PrayInfo)StorageManager.readCompressedObject(CU.getPrayFileName(prayName));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (prayInfo == null) {
            return null;
        }
        return prayInfo.getObject(key);
    }

    static {
        IGNORE_DATA = false;
        prayHash = new Hashtable();
    }
}

