/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history;

import bh.components.history.Merge;
import bh.components.history.RobotState;
import bh.units.Angle;
import bh.units.Distance;
import bh.units.Energy;
import bh.units.Heading;
import bh.units.Heat;
import bh.units.Location;
import bh.units.Speed;
import bh.units.Time;

public final class RobotRecord {
    private final Time time;
    private final String name;
    private final RobotState state;

    RobotRecord(String name, Time time, RobotState state) {
        this.name = name;
        this.time = time;
        this.state = state;
    }

    public String name() {
        return this.name;
    }

    public Time time() {
        return this.time;
    }

    public RobotState state() {
        return this.state;
    }

    private boolean empty() {
        return this.time() == null && this.name() == null && this.state().empty();
    }

    public RobotRecord conflicts(RobotRecord rr) {
        RobotRecord conflicts = new Builder().time(Merge.valueConflict(this.time(), rr.time())).name(Merge.valueConflict(this.name(), rr.name())).state(this.state().conflicts(rr.state())).build();
        if (conflicts.empty()) {
            return null;
        }
        return conflicts;
    }

    public RobotRecord merge(RobotRecord rr) {
        return new Builder().time(Merge.valueMerge(this.time(), rr.time())).name(Merge.valueMerge(this.name(), rr.name())).state(this.state().merge(rr.state())).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.time != null) {
            sb.append(" tm(").append(this.time).append(")");
        }
        if (this.name != null) {
            sb.append(" nm(").append(this.name).append(")");
        }
        if (this.state != null) {
            sb.append(" stt(").append(this.state).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RobotRecord)) {
            return false;
        }
        RobotRecord rr = (RobotRecord)o;
        boolean bl = this.time() == null ? rr.time() == null : (result = this.time().equals(rr.time()));
        boolean bl2 = result && (this.name() == null ? rr.name() == null : this.name().equals(rr.name())) ? true : (result = false);
        result = result && (this.state() == null ? rr.state() == null : this.state().equals(rr.state()));
        return result;
    }

    public int hashCode() {
        int hc = this.time() == null ? 0 : this.time().hashCode();
        hc = hc * 31 + (this.name() == null ? 0 : this.name().hashCode());
        hc = hc * 31 + (this.state() == null ? 0 : this.state().hashCode());
        return hc;
    }

    public static class Builder {
        public RobotState.Builder stateBuilder = new RobotState.Builder();
        public Time time = null;
        public String name = null;

        public RobotState.Builder stateBuilder() {
            if (this.stateBuilder == null) {
                this.stateBuilder = new RobotState.Builder();
            }
            return this.stateBuilder;
        }

        public Builder time(Time time) {
            this.time = time;
            return this;
        }

        public Builder time(long time) {
            return this.time(new Time(time));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder state(RobotState state) {
            if (state != null) {
                this.stateBuilder().energy(state.energy()).location(state.location()).heading(state.heading()).speed(state.speed()).gunHeading(state.gunHeading()).gunHeat(state.gunHeat()).radarHeading(state.radarHeading());
            }
            return this;
        }

        public Builder energy(Energy energy) {
            this.stateBuilder().energy(energy);
            return this;
        }

        public Builder energy(double energy) {
            return this.energy(new Energy(energy));
        }

        public Builder location(Location location) {
            this.stateBuilder().location(location);
            return this;
        }

        public Builder location(double x, double y) {
            return this.location(new Location(new Distance(x), new Distance(y)));
        }

        public Builder heading(Heading heading) {
            this.stateBuilder().heading(heading);
            return this;
        }

        public Builder heading(double heading) {
            return this.heading(new Heading(Angle.fromDegrees(heading)));
        }

        public Builder speed(Speed speed) {
            this.stateBuilder().speed(speed);
            return this;
        }

        public Builder speed(double speed) {
            return this.speed(new Speed(speed));
        }

        public Builder gunHeading(Heading gunHeading) {
            this.stateBuilder().gunHeading(gunHeading);
            return this;
        }

        public Builder gunHeading(double gunHeading) {
            return this.gunHeading(new Heading(Angle.fromDegrees(gunHeading)));
        }

        public Builder gunHeat(Heat gunHeat) {
            this.stateBuilder().gunHeat(gunHeat);
            return this;
        }

        public Builder gunHeat(double gunHeat) {
            return this.gunHeat(new Heat(gunHeat));
        }

        public Builder radarHeading(Heading radarHeading) {
            this.stateBuilder().radarHeading(radarHeading);
            return this;
        }

        public Builder radarHeading(double radarHeading) {
            return this.radarHeading(new Heading(Angle.fromDegrees(radarHeading)));
        }

        public RobotRecord build() {
            return new RobotRecord(this.name, this.time, this.stateBuilder.build());
        }
    }
}

