/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history.analysis;

import bh.components.history.Frame;
import bh.components.history.History;
import bh.components.history.RobotDelta;
import bh.components.history.RobotRecord;
import bh.components.history.RobotState;
import bh.facade.RulesFacade;
import bh.units.Distance;
import bh.units.Duration;
import bh.units.Energy;
import bh.units.Speed;
import bh.units.Time;
import bh.units.Units;
import java.util.Map;

public class HistoricalInferenceMaker {
    private final History history;
    private Time latestExhausted = Time.ZERO.minus(Duration.A_TURN);

    public HistoricalInferenceMaker(History history) {
        this.history = history;
    }

    public void inferAndStore() {
        Time t = this.latestExhausted.plus(Duration.A_TURN);
        while (Units.lessOrEqual(t, this.history.getLatestRecordedEvent())) {
            Frame frame = this.history.getFrame(t);
            this.inferAndStore(frame);
            t = t.plus(Duration.A_TURN);
        }
        this.latestExhausted = this.history.getLatestRecordedEvent();
    }

    private boolean hitWall(RobotState rs1, RobotState rs2) {
        RobotDelta d = rs2.minus(rs1);
        return Units.greater(d.speedDelta().abs(), new Speed(2.0)) && Units.lessOrEqual(RulesFacade.nearestWall(rs2.location()).getMagnitude(), new Distance(0.001));
    }

    private void inferAndStore(Frame frame) {
        if (Units.greater(frame.time, Time.ZERO)) {
            Frame prevFrame = this.history.getFrame(frame.time.minus(Duration.A_TURN));
            for (Map.Entry<String, RobotRecord> e : frame.robots.entrySet()) {
                RobotDelta delta;
                String botName = e.getKey();
                RobotRecord rr1 = prevFrame.robots.get(botName);
                RobotRecord rr2 = e.getValue();
                if (rr1 == null || (delta = rr2.state().minus(rr1.state())).energyDelta() == null) continue;
                delta.energyDelta().equals(Energy.ZERO);
            }
        }
    }
}

