/*
 * Decompiled with CFR 0.152.
 */
package bjl.fire;

import bjl.BattleField;
import bjl.Blip;
import bjl.Enemy;
import bjl.FireDemand;
import bjl.Point;
import bjl.fire.FireStrategy;

public class Straight
extends FireStrategy {
    public String toString() {
        return "Straight";
    }

    public Point getPosition(long time) {
        return this.enemy.getLastPosition();
    }

    protected FireDemand getFireDemand() {
        Point curPos = this.enemy.getLastPosition();
        Point myPos = BattleField.getPos();
        long time = BattleField.getTime();
        double dist = myPos.dist(curPos);
        double power = 0.5;
        double prob = -1.0;
        double bspeed = 20.0 - (double)3 * power;
        int i = (int)((double)time - curPos.dist(myPos) / bspeed);
        while ((long)i < time) {
            if (i < 0) {
                prob = this.getProb();
                break;
            }
            Blip b = this.enemy.getBlip(i);
            if (b != null && b.pos.dist(curPos) > 20.0) {
                prob = this.getProb();
                break;
            }
            ++i;
        }
        power = this.getPower(dist);
        if (power < 0.1) {
            power = 0.1;
        }
        if (power > (double)3) {
            power = 3;
        }
        if (this.bulletsFired < 5 && prob >= 0.0) {
            prob = 1.0;
        }
        return new FireDemand(power, prob, myPos.angleTo(curPos), dist, this);
    }

    public Straight(Enemy t) {
        super(t);
    }
}

