/*
 * Decompiled with CFR 0.152.
 */
package pedersen.misc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.misc.Vault;

public abstract class VaultBase
implements Vault {
    protected final Set vault = new HashSet();
    private long total = 0L;

    public void add(Debuggable entry) {
        this.vault.add(entry);
        ++this.total;
    }

    public void remove(Iterator iterator) {
        iterator.remove();
    }

    public Iterator iterator() {
        return this.vault.iterator();
    }

    public void purge() {
        this.vault.clear();
    }

    public void debug() {
        Debug.debug(String.valueOf(this.getClass().getSimpleName()) + ": " + this.vault.size() + " entries, " + this.total + " processed.");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Debuggable)iterator.next()).debug();
        }
    }
}

