/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import xander.gfws.distributer.TriangleDistributer;
import xander.gfws.distributer.WaveDistributer;
import xander.gfws.distributer.WeightDistributer;
import xander.gfws.modifier.FactorArrayModifier;
import xander.gfws.modifier.HeadOnFactorArrayModifier;
import xander.gfws.modifier.LinearFactorArrayModifier;

public class FactorArrayParms {
    WeightDistributer distributer;
    double weight = 3.0;
    FactorArrayModifier arrayInitializer;
    int maxDataPointsForUsingArrayInitializer = 0;
    boolean useFlattener = false;
    double useFlattenerOnHitPercentage;
    double useFlattenerVisitPercentage;
    int useFlattenerEarliestRound;
    int flattenerOnCount;
    int flattenerOffCount;
    boolean useBulletShadows = true;
    boolean varyWeightByAge = false;
    double decayPerTick = 0.0;
    boolean useCreativeAgeRoll = false;
    double minAgeWeightPercent = 0.01;
    double varyWeightByRankMultiplier = 1.0;

    public FactorArrayParms(boolean offensive) {
        if (offensive) {
            this.distributer = new TriangleDistributer();
            this.arrayInitializer = new LinearFactorArrayModifier(this.distributer, this.weight);
        } else {
            this.distributer = new WaveDistributer();
            this.arrayInitializer = new HeadOnFactorArrayModifier(this.distributer, this.weight);
        }
    }

    public void setMinAgeWeightPercent(double minAgeWeightPercent) {
        this.minAgeWeightPercent = minAgeWeightPercent;
    }

    public void setUseFlattener(boolean useFlattener, double opponentHitPercentage, double visitPercentage, int earliestRound) {
        this.useFlattener = useFlattener;
        this.useFlattenerOnHitPercentage = opponentHitPercentage;
        this.useFlattenerEarliestRound = earliestRound;
        this.useFlattenerVisitPercentage = visitPercentage;
    }

    public void setUseBulletShadows(boolean useBulletShadows) {
        this.useBulletShadows = useBulletShadows;
    }

    public void setVaryWeightByAge(double decayPerTick) {
        this.decayPerTick = decayPerTick;
        this.varyWeightByAge = decayPerTick > 0.0;
    }

    public void setUseCreativeAgeRoll(boolean useCreativeAgeRoll) {
        this.useCreativeAgeRoll = useCreativeAgeRoll;
    }

    public void setArrayInitializer(FactorArrayModifier arrayInitializer) {
        this.arrayInitializer = arrayInitializer;
    }

    public void setMaxDataPointsForUsingArrayInitializer(int maxDataPointsForUsingArrayInitializer) {
        this.maxDataPointsForUsingArrayInitializer = maxDataPointsForUsingArrayInitializer;
    }

    public double getVaryWeightByRankMultiplier() {
        return this.varyWeightByRankMultiplier;
    }

    public void setVaryWeightByRankMultiplier(double varyWeightByRankMultiplier) {
        this.varyWeightByRankMultiplier = varyWeightByRankMultiplier;
    }
}

