/*
 * Decompiled with CFR 0.152.
 */
package rjw.gun;

import java.awt.Color;
import rjw.Props;
import rjw.RabidWombat;
import rjw.gun.Gun;
import rjw.gun.GunData;
import rjw.gun.GunWave;
import rjw.pluggablerobot.Canvas;
import rjw.pluggablerobot.Hud;
import rjw.pluggablerobot.Math2;
import rjw.radar.Enemy;
import rjw.radar.EnemyScan;
import rjw.util.GuessFactor;
import rjw.util.Particle;
import robocode.util.Utils;

public class GuessFactorGun
extends Gun
implements Hud.Painter {
    private final Color GRAPH_COLOR = new Color(255, 255, 0, 128);
    private static GuessFactor _gf;
    private final int BINS;
    private final int DECAY;
    private int _enemyDirection = 1;

    public GuessFactorGun() {
        Props p = RabidWombat.getProps();
        this.BINS = p.getInt("gun.gf.bins", 25);
        this.DECAY = p.getInt("gun.gf.decay", 300);
        if (_gf == null) {
            _gf = new GuessFactor(this.BINS, this.DECAY);
        }
    }

    @Override
    public GunData fire(double power) {
        RabidWombat bot = (RabidWombat)this.getBot();
        EnemyScan currentScan = bot.getMemory().getTarget().get(0);
        Particle me = bot.getParticle();
        double currentEnemyBearing = me.getAbsoluteTargetBearing(currentScan);
        int direction = me.getTargetOrbitDirection(currentScan);
        this._enemyDirection = direction == 0 ? this._enemyDirection : direction;
        double escapeAngle = Math2.maxEscapeAngle(power);
        WaveData data = new WaveData(currentEnemyBearing, escapeAngle, this._enemyDirection);
        double fireAngle = _gf.fireHeading(currentEnemyBearing, this._enemyDirection, power);
        return new GunData(fireAngle, data);
    }

    @Override
    public void notifyHit(GunWave wave) {
        GunData data = wave.getGunData(this.getIndex());
        this.updateGuessFactor(data.getFireAngle(), (WaveData)data.getData());
    }

    @Override
    public void notifyMiss(GunWave wave, double perfectAngle) {
        GunData data = wave.getGunData(this.getIndex());
        this.updateGuessFactor(perfectAngle, (WaveData)data.getData());
    }

    private void updateGuessFactor(double angle, WaveData data) {
        double diff = Utils.normalRelativeAngle((double)(angle - data._angle));
        _gf.visit(Math2.limit(-1.0, diff / data._escapeAngle * (double)this._enemyDirection, 1.0));
    }

    @Override
    public Color getColor() {
        return Color.ORANGE;
    }

    @Override
    public void paint(Canvas canvas, long tick) {
        RabidWombat bot = (RabidWombat)this.getBot();
        Enemy enemy = bot.getMemory().getTarget();
        if (enemy == null) {
            return;
        }
        EnemyScan currentScan = enemy.get(0);
        Particle me = bot.getParticle();
        double currentEnemyBearing = me.getAbsoluteTargetBearing(currentScan);
        double escapeAngle = Math2.maxEscapeAngle(3.0);
        double[] bins = _gf.bins();
        int mid = (bins.length - 1) / 2;
        double startRadius = 40.0;
        canvas.setPaint(this.GRAPH_COLOR);
        int i = 0;
        while (i < bins.length) {
            double relAngle = escapeAngle * (double)(mid - i) / (double)mid * (double)(-this._enemyDirection);
            double absAngle = Utils.normalAbsoluteAngle((double)(currentEnemyBearing + relAngle));
            double magnitude = bins[i];
            double x1 = me.p().x + startRadius * Math.sin(absAngle);
            double y1 = me.p().y + startRadius * Math.cos(absAngle);
            double x2 = me.p().x + (magnitude + startRadius) * Math.sin(absAngle);
            double y2 = me.p().y + (magnitude + startRadius) * Math.cos(absAngle);
            canvas.drawLine(x1, y1, x2, y2);
            ++i;
        }
    }

    private class WaveData {
        protected double _angle;
        protected double _escapeAngle;
        protected int _direction;

        protected WaveData(double angle, double escapeAngle, int direction) {
            this._angle = angle;
            this._escapeAngle = escapeAngle;
            this._direction = direction;
        }
    }
}

