/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun.pif;

import catcat20.core.bot.Bot;
import catcat20.core.bot.BotState;
import catcat20.core.gun.Gun;
import catcat20.core.gun.pif.PIFData;
import catcat20.core.move.Surfing;
import catcat20.core.radar.Radar;
import catcat20.core.utils.LConstants;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.MovementPredictor;
import catcat20.core.utils.PreciseWallSmooth;
import catcat20.core.utils.knn.KNNData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class PlayItForward
extends Gun {
    public static int PATTERN_LENGTH = 1;
    public static int PATTERN_TICK = 1;
    ArrayList<Polygon> drawPathPolygons;
    ArrayList<Double> drawPathDistance;
    ArrayList<Integer> drawPathFire;
    ArrayList<Double> drawPathX;
    ArrayList<Double> drawPathY;
    ArrayList<Double> drawPosX;
    ArrayList<Double> drawPosY;
    int _others;
    boolean isPaint = false;
    boolean lastPaint = false;
    BasicStroke bs = new BasicStroke(2.5f);
    BasicStroke bsw = new BasicStroke(4.0f);
    Point2D.Double _myPos = new Point2D.Double();
    private static final double[] patDuelWeights = new double[]{3.0, 0.0, 7.0, 7.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 2.0, 0.0, 3.0, 3.0, 0.01, 3.0};
    public static final double[] duelPatternWeights;
    public static final double[] duelWeights;
    public static final double[] meleeWeight;
    public static boolean drawMEA;
    Color whiteRed = new Color(255, 180, 180);
    Color whiteBlue = new Color(180, 180, 255);
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
    BasicStroke pathSt = new BasicStroke(2.0f);

    public PlayItForward(TeamRobot _robot) {
        super(_robot);
    }

    @Override
    public void init() {
        this.drawPathFire = new ArrayList();
        this.drawPathX = new ArrayList();
        this.drawPathY = new ArrayList();
        this.drawPosX = new ArrayList();
        this.drawPosY = new ArrayList();
        this.drawPathDistance = new ArrayList();
        this.drawPathPolygons = new ArrayList();
        for (Bot bot : Radar.enemyList) {
            bot.stayPIFData.clear();
        }
    }

    @Override
    public void execute() {
        this.isPaint = this.lastPaint;
        this._others = this._robot.getOthers();
        double firePower = Radar.getFirePower();
        long time = this._robot.getTime();
        if (this._robot.getEnergy() >= 0.1) {
            for (Bot bot : Radar.enemyList) {
                ArrayList<PIFData> stayPIFData = bot.stayPIFData;
                for (int i = 0; i < stayPIFData.size(); ++i) {
                    PIFData stayedData = stayPIFData.get(i);
                    if (time - stayedData.putTime <= 20L) continue;
                    if (!stayedData.isMelee) {
                        bot.pifModel.addPoint(this.patternDataPoint(stayedData, PATTERN_LENGTH, PATTERN_TICK), stayedData);
                    } else {
                        bot.meleePIFModel.addPoint(this.meleeDataPoint(stayedData), stayedData);
                    }
                    stayPIFData.remove(i);
                    --i;
                }
                ArrayList<BotState> nearBotStates = null;
                BotState nearBot = null;
                if (bot.nearestBotName.equals(Radar.myName)) {
                    nearBot = Radar.myState;
                    nearBotStates = Radar.myStates;
                } else {
                    nearBot = Radar.getBot((String)bot.nearestBotName).currentState;
                    nearBotStates = Radar.getBot((String)bot.nearestBotName).states;
                }
                boolean canPut = false;
                if (this._others <= 1) {
                    canPut = bot.isAlive && bot.currentState != null && bot.states.size() > PATTERN_LENGTH * PATTERN_TICK + 1;
                } else {
                    boolean bl = canPut = bot.isAlive && bot.currentState != null && bot.states.size() > PATTERN_LENGTH * PATTERN_TICK + 1 && nearBot != null && nearBotStates.size() > 2;
                }
                if (!canPut) continue;
                PIFData data = new PIFData();
                data.myState = Radar.myState.clone();
                data.lastMyState = Radar.myStates.get(1);
                data.enState = bot.currentState;
                data.lastEnState = bot.states.get(1);
                data.power = firePower;
                data.dirChangeTime = bot.dirChangeTimeFromMe;
                data.velDirChangeTime = bot.velDirChangeTime;
                data.putTime = time;
                BotState state = bot.currentState;
                double velX = state.velocity * Math.sin(state.heading);
                double velY = state.velocity * Math.cos(state.heading);
                double distToWall = state.x;
                double advVelToNearestWall = -velX;
                if (LConstants.fieldWidth - state.x < distToWall) {
                    distToWall = LConstants.fieldWidth - state.x;
                    advVelToNearestWall = velX;
                }
                if (state.y < distToWall) {
                    distToWall = state.y;
                    advVelToNearestWall = -velY;
                }
                if (LConstants.fieldHeight - state.y < distToWall) {
                    distToWall = LConstants.fieldHeight - state.y;
                    advVelToNearestWall = velY;
                }
                data.wallDist = distToWall;
                data.advWallDist = advVelToNearestWall;
                double distToCorner = Double.POSITIVE_INFINITY;
                for (int i = 0; i < 4; ++i) {
                    distToCorner = Math.min(state.distanceSq(LConstants.cornerX[i], LConstants.cornerY[i]), distToCorner);
                }
                data.cornerDist = distToCorner = Math.sqrt(distToCorner);
                if (this._others > 1) {
                    data.nearState = nearBot;
                    data.lastNearState = nearBotStates.get(1);
                }
                BotState last120 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 120));
                data.dist120 = bot.currentState.distance(last120.x, last120.y);
                BotState last60 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 60));
                data.dist60 = bot.currentState.distance(last60.x, last60.y);
                BotState last30 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 30));
                data.dist30 = bot.currentState.distance(last30.x, last30.y);
                BotState last16 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 16));
                data.dist16 = bot.currentState.distance(last16.x, last16.y);
                BotState last8 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 8));
                data.dist8 = bot.currentState.distance(last8.x, last8.y);
                if (bot.lastPIFData != null) {
                    bot.lastPIFData.next = data;
                    data.back = bot.lastPIFData;
                }
                bot.lastPIFData = data;
                data.isMelee = true;
                if (this._others <= 1) {
                    data.isMelee = false;
                    data.shotsFired = bot.shotsFiredDuel;
                    data.mea = LUtils.maxEscapeAngle(Rules.getBulletSpeed((double)firePower));
                    data.meas = this.getMea(firePower, bot.currentState, Radar.myState.x, Radar.myState.y, 0L, 1, this._robot.getGraphics());
                    boolean notNull = true;
                    PIFData currentData = data;
                    for (int i = 0; i < PATTERN_LENGTH * PATTERN_TICK; ++i) {
                        currentData = currentData.back;
                        if (currentData != null) continue;
                        notNull = false;
                        break;
                    }
                    if (!notNull) continue;
                    bot.stayPIFData.add(data);
                    continue;
                }
                data.mea = LUtils.maxEscapeAngle(Rules.getBulletSpeed((double)firePower));
                data.meas = this.getMea(firePower, bot.currentState, nearBot.x, nearBot.y, 0L, 1, this._robot.getGraphics());
                bot.stayPIFData.add(data);
            }
        }
        this.lastPaint = false;
    }

    @Override
    public double getAngle(double power) {
        this._others = this._robot.getOthers();
        Graphics2D g = this._robot.getGraphics();
        this.drawPathX.clear();
        this.drawPathFire.clear();
        this.drawPathY.clear();
        this.drawPosX.clear();
        this.drawPosY.clear();
        this.drawPathPolygons.clear();
        double bulletPower = power;
        double bulletVel = Rules.getBulletSpeed((double)bulletPower);
        Point2D.Double myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        this._myPos = myPos = Surfing.nextMyPos;
        ArrayList firingAngles = new ArrayList();
        Point2D.Double drawPos = new Point2D.Double();
        for (Bot bot : Radar.enemyList) {
            if (!bot.isAlive || bot.currentState == null || bot.states.size() <= PATTERN_LENGTH * PATTERN_TICK * 2 + 2 || bot.lastPIFData == null) continue;
            double strongScore = bot.getStrongScore() / Radar.totalStrengthValue;
            ArrayList<MeleeFiringAngle> enemyAngles = new ArrayList<MeleeFiringAngle>();
            ArrayList<KNNData<PIFData>> nearestNeighbors = null;
            int k = 0;
            if (this._others <= 1) {
                int maxK = 20;
                k = (int)LUtils.limit(1.0, Math.sqrt(bot.pifModel.tree.size()), 20.0);
                nearestNeighbors = bot.pifModel.getNearestNeighborsList(this.patternDataPoint(bot.lastPIFData, PATTERN_LENGTH, PATTERN_TICK), k);
            } else {
                k = (int)(75.0 / (double)this._others) + 1;
                k = Math.min(k, (int)Math.sqrt(bot.meleePIFModel.tree.size()) + 1);
                nearestNeighbors = bot.meleePIFModel.getNearestNeighborsList(this.meleeDataPoint(bot.lastPIFData), k);
            }
            double totalWeight = 0.0;
            for (KNNData<PIFData> data : nearestNeighbors) {
                Point2D.Double pos = this.simPos((PIFData)data.data, bulletVel, bot.lastPIFData);
                if (pos == null || !LConstants.field.contains(pos)) continue;
                double fireAngle = LUtils.absoluteBearing(myPos, pos);
                double preEnDist = myPos.distance(pos);
                double scanWeight = 1.0 / data.distance;
                if (this._others > 1) {
                    scanWeight *= strongScore;
                }
                double bandwidth = Math.asin(36.0 / preEnDist);
                totalWeight += scanWeight;
                MeleeFiringAngle angle = new MeleeFiringAngle(fireAngle, preEnDist, bandwidth, scanWeight);
                enemyAngles.add(angle);
                if (!this.isPaint) continue;
                this.drawPosX.add(pos.x);
                this.drawPosY.add(pos.y);
                this.drawPathFire.add(((PIFData)data.data).shotsFired);
                this.drawPathDistance.add(data.distance);
                LUtils.projectWithCache(myPos, angle.angle, 130.0, drawPos);
                g.setColor(Color.lightGray);
                g.drawLine((int)myPos.x, (int)myPos.y, (int)drawPos.x, (int)drawPos.y);
            }
            for (MeleeFiringAngle angle : enemyAngles) {
                angle.scanWeight /= totalWeight;
            }
            firingAngles.addAll(enemyAngles);
        }
        Double bestAngle = null;
        double bestDensity = Double.NEGATIVE_INFINITY;
        for (MeleeFiringAngle xFiringAngle : firingAngles) {
            double xDensity = 0.0;
            for (MeleeFiringAngle yFiringAngle : firingAngles) {
                double ux = Utils.normalRelativeAngle((double)(xFiringAngle.angle - yFiringAngle.angle)) / yFiringAngle.bandwidth;
                xDensity += yFiringAngle.scanWeight * Math.exp(-0.5 * ux * ux) / yFiringAngle.distance;
            }
            if (!(xDensity > bestDensity)) continue;
            bestAngle = xFiringAngle.angle;
            bestDensity = xDensity;
        }
        if (bestAngle == null) {
            return Double.POSITIVE_INFINITY;
        }
        Stroke reset = g.getStroke();
        g.setStroke(this.bsw);
        LUtils.projectWithCache(myPos, bestAngle, 1500.0, drawPos);
        g.setColor(Color.white);
        g.drawLine((int)myPos.x, (int)myPos.y, (int)drawPos.x, (int)drawPos.y);
        g.setStroke(this.bs);
        LUtils.projectWithCache(myPos, bestAngle, 1500.0, drawPos);
        g.setColor(this.getColor());
        g.drawLine((int)myPos.x, (int)myPos.y, (int)drawPos.x, (int)drawPos.y);
        g.setStroke(reset);
        return bestAngle;
    }

    public Point2D.Double simPos(PIFData data, double bulletVel, PIFData currentData) {
        Polygon polygon = null;
        Point2D.Double pos = new Point2D.Double(currentData.enState.x, currentData.enState.y);
        double heading = currentData.enState.heading;
        double velocity = currentData.enState.velocity;
        PIFData next = data;
        if (next != null && next.next == null) {
            return null;
        }
        double distanceTraveled = 0.0;
        double dist = Point2D.Double.distanceSq(data.enState.x, data.enState.y, this._myPos.x, this._myPos.y);
        int tick = 0;
        do {
            ++tick;
            distanceTraveled += bulletVel;
            next = next.next;
            if (next != null) {
                double headingChange = -next.back.enState.heading + next.enState.heading;
                heading += headingChange;
                double vel = next.enState.velocity;
                velocity = MovementPredictor.getVelocity(velocity, vel, 1000.0);
                if (this._myPos.distanceSq(pos) <= 625.0) {
                    vel = 0.0;
                }
                LUtils.projectWithCache(pos, heading, vel, pos);
                if (this.isPaint) {
                    if (polygon == null) {
                        polygon = new Polygon();
                    }
                    polygon.addPoint((int)pos.x, (int)pos.y);
                }
                dist = Point2D.Double.distanceSq(pos.x, pos.y, this._myPos.x, this._myPos.y);
                continue;
            }
            pos = null;
        } while (next != null && distanceTraveled * distanceTraveled < dist && tick < 1000 && pos != null);
        if (this.isPaint) {
            this.drawPathPolygons.add(polygon);
        }
        if (next == null || next.next == null) {
            return null;
        }
        return pos;
    }

    public double[] patDataPoint(PIFData data) {
        double distance = data.enState.distance(data.myState.x, data.myState.y);
        double bft = distance / Rules.getBulletSpeed((double)data.power);
        double latVel = Bot.lateralVelocity(data.myState, data.enState);
        double advVel = Bot.advancingVelocity(data.myState, data.enState);
        double headingChange = (Utils.normalRelativeAngle((double)(data.enState.heading - data.lastEnState.heading)) + Rules.MAX_TURN_RATE_RADIANS) / (Rules.MAX_TURN_RATE_RADIANS * 2.0);
        double lastLatVel = Bot.lateralVelocity(data.lastMyState, data.lastEnState);
        double accel = LUtils.accel(Math.abs(latVel), Math.abs(lastLatVel));
        return new double[]{bft / 91.0, (data.enState.velocity + 8.0) / 16.0, (latVel + 8.0) / 16.0, (lastLatVel + 8.0) / 16.0, (advVel + 8.0) / 16.0, (accel + 2.0) / 3.0, data.dist16 / 128.0, data.dist30 / 240.0, data.dist60 / 480.0, data.dist120 / 960.0, LUtils.limit(0.0, data.dirChangeTime / 30.0, 1.0), headingChange, data.meas[0] / data.mea, data.meas[1] / data.mea, (double)data.shotsFired / 2.0E7, ((double)LUtils.sign(data.enState.velocity) + 1.0) / 2.0};
    }

    public double[] dataPoint(PIFData data) {
        double distance = data.enState.distance(data.myState.x, data.myState.y);
        double latVel = Bot.lateralVelocity(data.myState, data.enState);
        double advVel = Bot.advancingVelocity(data.myState, data.enState);
        double lastLatVel = Bot.lateralVelocity(data.lastMyState, data.lastEnState);
        double accel = LUtils.accel(Math.abs(latVel), Math.abs(lastLatVel));
        return new double[]{distance / 1300.0, (latVel + 8.0) / 16.0, (advVel + 8.0) / 16.0, (accel + 2.0) / 3.0, data.dist16 / 128.0, data.dist30 / 240.0, LUtils.limit(0.0, data.dirChangeTime / 30.0, 1.0), data.meas[0] / data.mea, data.meas[1] / data.mea};
    }

    public double[] patternDataPoint(PIFData data, int putPatSize, int tick) {
        int dataSize = patDuelWeights.length;
        double[] patternDataPoint = new double[dataSize * putPatSize];
        PIFData currentData = data;
        int count = 0;
        for (int i = 0; i < putPatSize * tick; ++i) {
            if (i % tick == 0) {
                double[] point = this.patDataPoint(currentData);
                System.arraycopy(point, 0, patternDataPoint, count * dataSize + 0, point.length);
                ++count;
            }
            currentData = currentData.back;
        }
        return patternDataPoint;
    }

    public double[] meleeDataPoint(PIFData data) {
        double distance = data.enState.distance(data.myState.x, data.myState.y);
        double accel = LUtils.accel(Math.abs(data.enState.velocity), Math.abs(data.lastEnState.velocity));
        double nearDistance = data.nearState.distance(data.enState.x, data.enState.y);
        double nearLatVel = Bot.lateralVelocity(data.enState, data.nearState);
        double nearAdvVel = Bot.advancingVelocity(data.enState, data.nearState);
        return new double[]{distance / 1300.0, (data.enState.velocity + 8.0) / 16.0, (data.lastEnState.velocity + 8.0) / 16.0, (accel + 2.0) / 3.0, data.dist8 / 64.0, data.dist16 / 128.0, data.dist30 / 240.0, data.dist120 / 960.0, LUtils.limit(0.0, data.velDirChangeTime / 30.0, 1.0), Math.min(1.0, this.directToWallDistance(data.enState.x, data.enState.y, distance, data.enState.heading, data.power)), nearDistance / 1300.0, (nearLatVel + 8.0) / 16.0, (nearAdvVel + 8.0) / 16.0, data.meas[0] / data.mea, data.meas[1] / data.mea, data.wallDist / 500.0, (data.advWallDist + 8.0) / 16.0, data.cornerDist / 500.0, ((double)LUtils.sign(data.enState.velocity) + 1.0) / 2.0};
    }

    public double[] getMea(double power, BotState en, double myX, double myY, long time, int direction, Graphics2D g) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double absBearing = LUtils.absoluteBearing(myX, myY, en.x, en.y);
        double distance = Point2D.Double.distance(myX, myY, en.x, en.y);
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = Point2D.Double.distance(myX, myY, dir1.x, dir1.y);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir1.x, dir1.y, myX, myY) + 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir1.x, dir1.y, -1 * direction);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
            if (g == null || !drawMEA) continue;
            g.setColor(this.whiteRed);
            g.drawOval((int)dir1.x - 1, (int)dir1.y - 1, 2, 2);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = Point2D.Double.distance(myX, myY, dir2.x, dir2.y);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir2.x, dir2.y, myX, myY) - 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir2.x, dir2.y, direction);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
            if (g == null || !drawMEA) continue;
            g.setColor(this.whiteRed);
            g.drawOval((int)dir2.x - 1, (int)dir2.y - 1, 2, 2);
        }
        double mea1 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir1.x, dir1.y) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir2.x, dir2.y) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double directToWallDistance(double posx, double posy, double distance, double heading, double bulletPower) {
        int bulletTicks = LUtils.bulletTicksFromPower(distance, bulletPower);
        double wallDistance = 2.0;
        double sinHeading = Math.sin(heading);
        double cosHeading = Math.cos(heading);
        for (int x = 0; x < 2 * bulletTicks; ++x) {
            if (LConstants.field.contains(posx + sinHeading * 8.0 * (double)x, posy + cosHeading * 8.0 * (double)x)) continue;
            wallDistance = (double)x / (double)bulletTicks;
            break;
        }
        return wallDistance;
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public Color getColor() {
        return Color.magenta;
    }

    @Override
    public String getLabel() {
        return "PIF";
    }

    @Override
    public void onPaint(Graphics2D g) {
        this.lastPaint = true;
        g.setColor(new Color(0.75f, 0.0f, 0.0f, 0.375f));
        int size = 1;
        Stroke cache = g.getStroke();
        g.setStroke(this.pathSt);
        for (Polygon polygon : this.drawPathPolygons) {
            g.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        }
        g.setStroke(cache);
        Color red = new Color(1.0f, 0.0f, 0.0f, 0.175f);
        size = 18;
        for (int i = 0; i < this.drawPosX.size(); ++i) {
            double x = this.drawPosX.get(i);
            double y = this.drawPosY.get(i);
            int shotFired = this.drawPathFire.get(i);
            double dist = this.drawPathDistance.get(i);
            g.setColor(red);
            g.fillRect((int)x - size, (int)y - size, size * 2, size * 2);
            g.setColor(Color.white);
            if (this._others <= 1) {
                g.drawString("" + shotFired, (int)x - 16, (int)y - 12);
            }
            g.drawString(String.valueOf((double)((int)(dist * 1000.0)) / 1000.0), (int)x - 16, (int)y + 4);
        }
    }

    static {
        double[] patternWeights = new double[patDuelWeights.length * PATTERN_LENGTH];
        for (int i = 0; i < PATTERN_LENGTH; ++i) {
            for (int j = 0; j < patDuelWeights.length; ++j) {
                patternWeights[i * PlayItForward.patDuelWeights.length + j] = patDuelWeights[j];
            }
        }
        duelPatternWeights = patternWeights;
        duelWeights = new double[]{1.0, 8.0, 2.0, 4.0, 3.0, 3.0, 3.0, 3.0, 3.0};
        meleeWeight = new double[]{0.0, 0.0, 0.0, 0.0, 2.0, 2.0, 2.0, 0.0, 2.5, 0.0, 4.0, 5.0, 3.0, 1.0, 1.0, 5.0, 5.0, 2.25, 2.0};
        drawMEA = false;
    }

    private static class MeleeFiringAngle {
        public final double angle;
        public final double distance;
        public final double bandwidth;
        public double scanWeight;

        public MeleeFiringAngle(double angle, double distance, double bandwidth, double scanWeight) {
            this.angle = angle;
            this.distance = distance;
            this.bandwidth = bandwidth;
            this.scanWeight = scanWeight;
        }
    }
}

