/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.GunManager;
import divineomega.MovementMode;
import divineomega.TrialBot;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.RobocodeFileOutputStream;

public abstract class FileManager {
    public static void load(File file) {
        TrialBot.output("Loading from '" + file.getAbsolutePath() + "'...");
        if (!file.exists()) {
            TrialBot.output("File does not exist yet.");
            return;
        }
        if (!file.canRead()) {
            TrialBot.output("Can not read from file.");
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ZipInputStream zis = new ZipInputStream(fis);
            zis.getNextEntry();
            ObjectInputStream ois = new ObjectInputStream(zis);
            GunManager.setEnemyNameToGunList((HashMap)ois.readObject());
            MovementMode.setModeData((HashMap)ois.readObject());
            MovementMode.setWins((HashMap)ois.readObject());
            MovementMode.setRounds((HashMap)ois.readObject());
            TrialBot.gunAngles = (HashMap)ois.readObject();
            TrialBot.bulletShieldFailureCount = (HashMap)ois.readObject();
            ois.close();
            TrialBot.output("Loading complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
            TrialBot.output("Error loading file. New file will be created at the end of the round.");
        }
    }

    public static void save(File file) {
        TrialBot.output("Saving to '" + file.getAbsolutePath() + "'...");
        try {
            RobocodeFileOutputStream fos = new RobocodeFileOutputStream(file);
            ZipOutputStream zos = new ZipOutputStream((OutputStream)fos);
            zos.putNextEntry(new ZipEntry(file.getName()));
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(GunManager.getEnemyNameToGunList());
            oos.writeObject(MovementMode.getModeData());
            oos.writeObject(MovementMode.getWins());
            oos.writeObject(MovementMode.getRounds());
            oos.writeObject(TrialBot.gunAngles);
            oos.writeObject(TrialBot.bulletShieldFailureCount);
            oos.flush();
            zos.closeEntry();
            oos.close();
            TrialBot.output("Saving complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void quotaCheck(long dataQuotaAvailable, File dataDirectory) {
        TrialBot.output("Checking data quota...");
        if (dataQuotaAvailable <= 0L) {
            File[] filesToDelete;
            TrialBot.output("Over quota! Looking up files...");
            File[] fileArray = filesToDelete = dataDirectory.listFiles();
            int n = filesToDelete.length;
            int n2 = 0;
            while (n2 < n) {
                File fileToDelete = fileArray[n2];
                TrialBot.output("Deleting file '" + fileToDelete.getAbsolutePath() + "'...");
                fileToDelete.delete();
                ++n2;
            }
        }
        TrialBot.output("Quota check complete.");
    }

    public static void deleteUnnecessary(File dataFile, File dataDirectory) {
        File[] filesToDelete;
        TrialBot.output("Checking for unnecessary files...");
        File[] fileArray = filesToDelete = dataDirectory.listFiles();
        int n = filesToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            File fileToDelete = fileArray[n2];
            if (!fileToDelete.getAbsolutePath().equals(dataFile.getAbsolutePath())) {
                TrialBot.output("Deleting unnecessary '" + fileToDelete.getAbsolutePath() + "'...");
                fileToDelete.delete();
            }
            ++n2;
        }
        TrialBot.output("Unnecessary file check complete.");
    }
}

