/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Vector;
import krillr.mega.utils.BattleTracker;
import krillr.mega.utils.DebugShape;
import krillr.mega.utils.KrillrUtil;
import krillr.mega.utils.Module;
import krillr.mega.utils.MovementManager;
import krillr.mega.utils.Point2d;
import krillr.mega.utils.UnitTracker;
import krillr.mega.utils.Vector2d;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;

public class KrillrRobot
extends TeamRobot {
    public Vector modules = new Vector();
    public ArrayList shapeList = new ArrayList();
    public UnitTracker currentTarget;
    public BattleTracker battleTracker;
    public MovementManager movementManager;
    public Line2D.Double westWall;
    public Line2D.Double eastWall;
    public Line2D.Double southWall;
    public Line2D.Double northWall;
    boolean debug = true;
    double enemyAbsoluteBearing;
    int timeSinceLastScan;

    public void run() {
        Module m;
        int i;
        this.battleTracker = new BattleTracker(this);
        this.movementManager = new MovementManager(this);
        this.westWall = new Line2D.Double(0.0, 0.0, 0.0, this.getBattleFieldHeight());
        this.eastWall = new Line2D.Double(this.getBattleFieldWidth(), 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.northWall = new Line2D.Double(0.0, this.getBattleFieldHeight(), this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.southWall = new Line2D.Double(0.0, 0.0, this.getBattleFieldWidth(), 0.0);
        this.handleStartup();
        this.battleTracker.handleStartup();
        this.movementManager.handleStartup();
        for (i = 0; i < this.modules.size(); ++i) {
            m = (Module)this.modules.get(i);
            m.handleStartup();
            this.modules.set(i, m);
        }
        while (true) {
            this.doScan();
            this.battleTracker.handleTurn(this.getTime());
            this.movementManager.handleTurn(this.getTime());
            this.currentTarget = this.battleTracker.getClosestUnit(false);
            for (i = 0; i < this.modules.size(); ++i) {
                m = (Module)this.modules.get(i);
                m.handleTurn(this.getTime());
                this.modules.set(i, m);
            }
            this.handleTurn(this.getTime());
            this.execute();
        }
    }

    public void doScan() {
        ++this.timeSinceLastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.timeSinceLastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - this.enemyAbsoluteBearing));
            radarOffset += (double)this.sign(radarOffset) * 0.02;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    int sign(double v) {
        return v > 0.0 ? 1 : -1;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.timeSinceLastScan = 0;
        this.handleScan(e);
        this.battleTracker.handleScan(e);
        this.movementManager.handleScan(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleScan(e);
            this.modules.set(i, m);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.handleBulletHit(e);
        this.battleTracker.handleBulletHit(e);
        this.movementManager.handleBulletHit(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleBulletHit(e);
            this.modules.set(i, m);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.handleBulletHitBullet(e);
        this.battleTracker.handleBulletHitBullet(e);
        this.movementManager.handleBulletHitBullet(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleBulletHitBullet(e);
            this.modules.set(i, m);
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.handleBulletMissed(e);
        this.battleTracker.handleBulletMissed(e);
        this.movementManager.handleBulletMissed(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleBulletMissed(e);
            this.modules.set(i, m);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.handleHitByBullet(e);
        this.battleTracker.handleHitByBullet(e);
        this.movementManager.handleHitByBullet(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleHitByBullet(e);
            this.modules.set(i, m);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        this.handleHitRobot(e);
        this.battleTracker.handleHitRobot(e);
        this.movementManager.handleHitRobot(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleHitRobot(e);
            this.modules.set(i, m);
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.handleHitWall(e);
        this.battleTracker.handleHitWall(e);
        this.movementManager.handleHitWall(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleHitWall(e);
            this.modules.set(i, m);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.handleRobotDeath(e);
        this.battleTracker.handleRobotDeath(e);
        this.movementManager.handleRobotDeath(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleRobotDeath(e);
            this.modules.set(i, m);
        }
    }

    public void onWin(WinEvent e) {
        this.handleWin(e);
        this.battleTracker.handleWin(e);
        this.movementManager.handleWin(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleWin(e);
            this.modules.set(i, m);
        }
    }

    public void onDeath(DeathEvent e) {
        this.handleDeath(e);
        this.battleTracker.handleDeath(e);
        this.movementManager.handleDeath(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleDeath(e);
            this.modules.set(i, m);
        }
    }

    public void onMessagedReceived(MessageEvent e) {
        this.handleMessage(e);
        this.battleTracker.handleMessage(e);
        this.movementManager.handleMessage(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleMessage(e);
            this.modules.set(i, m);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.handleSkippedTurn(e);
        this.battleTracker.handleSkippedTurn(e);
        this.movementManager.handleSkippedTurn(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleSkippedTurn(e);
            this.modules.set(i, m);
        }
        this.out.println("Omfg i skipped a turn?!");
    }

    public void onPaint(Graphics2D g) {
        this.handlePaint(g);
        this.battleTracker.handlePaint(g);
        this.movementManager.handlePaint(g);
        for (DebugShape shape : this.shapeList) {
            g.setColor(shape.color);
            g.draw(shape.shape);
        }
        this.shapeList = new ArrayList();
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handlePaint(g);
            this.modules.set(i, m);
        }
    }

    public void onCustomEvent(CustomEvent e) {
        this.handleCustomEvent(e);
        this.battleTracker.handleCustomEvent(e);
        this.movementManager.handleCustomEvent(e);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleCustomEvent(e);
            this.modules.set(i, m);
        }
    }

    public void firebullet(double energy) {
        Bullet bullet = this.setFireBullet(energy);
        this.handleFiredBullet(bullet);
        this.battleTracker.handleFiredBullet(bullet);
        this.movementManager.handleFiredBullet(bullet);
        for (int i = 0; i < this.modules.size(); ++i) {
            Module m = (Module)this.modules.get(i);
            m.handleFiredBullet(bullet);
            this.modules.set(i, m);
        }
    }

    public void handleStartup() {
    }

    public void handleTurn(long t) {
    }

    public void handleScan(ScannedRobotEvent e) {
    }

    public void handleBulletHit(BulletHitEvent e) {
    }

    public void handleBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void handleBulletMissed(BulletMissedEvent e) {
    }

    public void handleHitByBullet(HitByBulletEvent e) {
    }

    public void handleHitRobot(HitRobotEvent e) {
    }

    public void handleHitWall(HitWallEvent e) {
    }

    public void handleRobotDeath(RobotDeathEvent e) {
    }

    public void handleWin(WinEvent e) {
    }

    public void handleDeath(DeathEvent e) {
    }

    public void handleMessage(MessageEvent e) {
    }

    public void handleSkippedTurn(SkippedTurnEvent e) {
    }

    public void handlePaint(Graphics2D g) {
    }

    public void handleCustomEvent(CustomEvent e) {
    }

    public void handleFiredBullet(Bullet b) {
    }

    public Point2d location() {
        return new Point2d(this.getX(), this.getY());
    }

    public Vector2d vector() {
        return new Vector2d(this.getVelocity(), this.getHeadingRadians());
    }

    public void setVector(Vector2d v) {
        double direction = KrillrUtil.bestAngle(v.angle() - this.getHeadingRadians());
        this.setTurnRightRadians(direction);
        this.setMaxVelocity(8.0);
        this.setAhead(100.0);
    }

    public void setBackAsFront(double goAngle) {
        double angle = goAngle;
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                this.setTurnRightRadians(Math.PI + angle);
            } else {
                this.setTurnLeftRadians(Math.PI - angle);
            }
            this.setBack(100.0);
        } else {
            if (angle < 0.0) {
                this.setTurnLeftRadians(-1.0 * angle);
            } else {
                this.setTurnRightRadians(angle);
            }
            this.setAhead(100.0);
        }
    }

    public void debug(Object o) {
        if (this.debug) {
            this.out.println(o);
        }
    }
}

