/*
 * Decompiled with CFR 0.152.
 */
package non.mega;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class NoName
extends AdvancedRobot {
    boolean firstScan = true;
    static String e_name;
    double e_x;
    double e_y;
    double e_absBear;
    double e_dist;
    double e_head;
    double e_energy;
    double e_speed;
    double radarTurnAngle = 5.0;
    double startRadarTurnAngle = 5.0;
    double radarTurnDir = 1.0;
    public int distCorrAngle = 12;
    public int moveDir = 1;
    double fieldX;
    double fieldY;
    double border = 25.0;
    static Polygon field;
    Vector vbs;
    static int[][][][][] stats;

    public void run() {
        this.startInit();
        while (true) {
            this.radarTurnAngle += 3.0;
            this.scan();
            this.move();
            this.doVBs();
            this.execute();
        }
    }

    public void scan() {
        if (!this.firstScan && Math.abs(this.getGunTurnRemaining()) < 2.0) {
            this.setTurnRadarRight(this.normalRelativeAngle(this.e_absBear - this.getRadarHeading() + this.radarTurnAngle * this.radarTurnDir));
            this.radarTurnDir *= -1.0;
        }
    }

    public void move() {
        if (Math.random() > 0.97) {
            this.moveDir *= -1;
        }
        double startX = this.getX();
        double startY = this.getY();
        double moveDist = (Math.random() * 200.0 + 8.0) * (double)this.moveDir;
        double angleCorrection = 0.0;
        double angle = this.e_absBear + 90.0 + angleCorrection;
        while (angle > this.e_absBear) {
            double endY;
            double endX = startX + moveDist * 4.0 * Math.sin(Math.toRadians(angle));
            if (this.inField(endX, endY = startY + moveDist * 4.0 * Math.cos(Math.toRadians(angle)))) {
                this.setMaxTurnRate(Math.abs(angle - this.getHeading()) / (moveDist / 8.0));
                this.setTurnRight(this.normalRelativeAngle(angle - this.getHeading()));
                this.setMaxVelocity(Math.random() > 0.7 ? Math.random() * 20.0 : 8.0);
                this.setAhead(moveDist);
                return;
            }
            angle -= 2.0;
        }
    }

    public void doVBs() {
        double now = this.getTime();
        Enumeration e = this.vbs.elements();
        while (e.hasMoreElements()) {
            Bullet b = (Bullet)e.nextElement();
            double distTraveled = b.velocity * (now - b.fireTime);
            double dist = Point2D.distance(this.e_x, this.e_y, b.startX, b.startY);
            if (!(Math.abs(distTraveled - dist) <= b.velocity / 2.0)) continue;
            int i = 0;
            while (i < b.spectra.length) {
                double endY;
                double endX = b.startX + distTraveled * Math.sin(Math.toRadians(b.spectra[i]));
                if (Point2D.distance(endX, endY = b.startY + distTraveled * Math.cos(Math.toRadians(b.spectra[i])), this.e_x, this.e_y) < 15.0) {
                    int[] nArray = stats[b.distIndex][b.relHeadIndex][b.acclIndex][b.speedIndex];
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                }
                ++i;
            }
            this.vbs.remove(b);
        }
    }

    public void startInit() {
        this.fieldX = this.getBattleFieldWidth();
        this.fieldY = this.getBattleFieldHeight();
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setColors(Color.black, Color.red.brighter().brighter(), Color.yellow);
        if (this.fieldX > 800.0 || this.fieldY < 600.0 || this.getOthers() > 1) {
            System.out.println("Just 1v1");
            while (true) {
                this.execute();
            }
        }
        if (field == null) {
            this.calcPolygon();
        }
        this.vbs = new Vector();
        while (this.firstScan) {
            if (Math.abs(this.getRadarTurnRemaining()) < 2.0) {
                this.setTurnRadarRight(15.0);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.firstScan) {
            if (e_name == null) {
                e_name = e.getName();
                this.readDat();
            }
            this.firstScan = false;
            this.setTurnRight(this.normalRelativeAngle(e.getBearing() + 90.0));
            this.setTurnGunRight(this.normalRelativeAngle(e.getBearing() + this.getHeading() - this.getGunHeading()));
            this.execute();
        }
        this.radarTurnAngle = this.startRadarTurnAngle;
        this.e_absBear = e.getBearing() + this.getHeading();
        this.e_dist = e.getDistance();
        this.e_x = this.getX() + this.e_dist * Math.sin(Math.toRadians(this.e_absBear));
        this.e_y = this.getY() + this.e_dist * Math.cos(Math.toRadians(this.e_absBear));
        double accl = e.getVelocity() - this.e_speed;
        this.e_speed = e.getVelocity();
        this.e_head = e.getHeading();
        this.e_energy = e.getEnergy();
        if (this.getGunHeat() < 3.0 && Math.abs(this.getGunTurnRemaining()) < 0.5) {
            double firePower = this.getFirePower();
            double hisHead = this.e_head * (this.e_speed > 0.0 ? 1.0 : (this.e_speed < 0.0 ? -1.0 : (Math.random() > 0.5 ? -1.0 : 1.0)));
            double relHeading = this.normalRelativeAngle(hisHead - this.e_absBear);
            if (relHeading < 0.0) {
                relHeading = 180.0 + relHeading;
            }
            boolean clockwiseIndex = this.normalAbsoluteAngle((this.e_head - this.e_absBear) * (this.e_speed > 0.0 ? 1.0 : (this.e_speed < 0.0 ? -1.0 : (Math.random() > 0.5 ? 1.0 : -1.0)))) < 179.0;
            int distIndex = (int)(this.e_dist * 0.02);
            int acclIndex = accl > 1.0 ? 2 : (accl < 1.0 ? 1 : 0);
            int speedIndex = Math.abs(this.e_speed) > 4.0 ? 1 : 0;
            double maxBearing = this.getMaxBearing(firePower) * (!clockwiseIndex ? -1.0 : 1.0);
            int relHeadIndex = 0;
            double factor = this.toFactor(this.getBestFactor(stats[distIndex][relHeadIndex][acclIndex][speedIndex]));
            this.setTurnGunRight(this.normalRelativeAngle(this.e_absBear - this.getGunHeading() + maxBearing * factor));
            if (Math.max(firePower, 0.1) >= this.getEnergy()) {
                return;
            }
            if (this.setFireBullet(firePower) != null) {
                double startX = this.getX();
                double startY = this.getY();
                Bullet b = new Bullet();
                b.distIndex = distIndex;
                b.relHeadIndex = relHeadIndex;
                b.acclIndex = acclIndex;
                b.speedIndex = speedIndex;
                b.maxBearing = maxBearing;
                b.spectra = new double[41];
                int i = 0;
                while (i < b.spectra.length) {
                    b.spectra[i] = this.e_absBear + maxBearing * this.toFactor(i);
                    ++i;
                }
                b.velocity = this.bulletVelocity(firePower);
                b.absBear = this.e_absBear;
                b.startX = startX;
                b.startY = startY;
                b.fireTime = this.getTime();
                this.vbs.add(b);
            }
        }
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Hit wall");
    }

    public void onWin(WinEvent e) {
        this.end();
    }

    public void onDeath(DeathEvent e) {
        this.end();
    }

    public void end() {
        this.saveDat();
    }

    public void readDat() {
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.getDataFile(e_name + ".dat.zip"))));
            stats = (int[][][][][])in.readObject();
            in.close();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                System.out.println("New bot:" + e_name);
            } else {
                System.out.println("IOError while reading:" + e);
            }
            stats = new int[20][4][3][2][41];
        }
    }

    public void saveDat() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(e_name + ".dat.zip"))));
            out.writeObject(stats);
            out.close();
        }
        catch (Exception e) {
            System.out.println("IOError while saving:" + e);
        }
    }

    double toFactor(int index) {
        return (double)(index - 20) * 0.05;
    }

    void calcPolygon() {
        int width = (int)this.fieldX;
        int height = (int)this.fieldY;
        int border = (int)this.border;
        int xecke = 70;
        int yecke = 70;
        int[] xs = new int[]{border + xecke, width - border - xecke, width - border, width - border, width - border - xecke, border + xecke, border, border};
        int[] ys = new int[]{height - border, height - border, height - border - yecke, yecke + border, border, border, border + yecke, height - border - yecke};
        field = new Polygon(xs, ys, xs.length);
    }

    int getBestFactor(int[] sp) {
        Vector<Integer> sameBestFactors = new Vector<Integer>();
        double bestValue = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < sp.length) {
            int thisValue = sp[i];
            if ((double)thisValue == bestValue) {
                sameBestFactors.add(new Integer(i));
            }
            if ((double)thisValue > bestValue) {
                sameBestFactors.removeAllElements();
                sameBestFactors.add(new Integer(i));
                bestValue = thisValue;
            }
            ++i;
        }
        int bestFactorIndex = 20;
        bestFactorIndex = sameBestFactors.size() == 41 ? 25 : (sameBestFactors.size() == 1 ? ((Integer)sameBestFactors.elementAt(0)).intValue() : ((Integer)sameBestFactors.elementAt((int)(Math.random() * (double)sameBestFactors.size()))).intValue());
        return bestFactorIndex;
    }

    double getMaxBearing(double power) {
        return Math.toDegrees(Math.abs(Math.asin(8.0 / this.bulletVelocity(power))));
    }

    double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public double normalRelativeAngle(double angle) {
        return Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(angle)));
    }

    public double normalAbsoluteAngle(double angle) {
        return Math.toDegrees(Utils.normalAbsoluteAngle((double)Math.toRadians(angle)));
    }

    public double getKillPower(double enemyPower) {
        if (enemyPower >= 4.0) {
            return enemyPower / 4.0;
        }
        return (enemyPower - 2.0) / 6.0;
    }

    public double getDamage(double power) {
        return Math.max(4.0 * power, 6.0 * power - 2.0);
    }

    public double distToWall(double x, double y) {
        return Math.min(Math.min(x, y), Math.min(this.fieldY - x, this.fieldY - y));
    }

    public double getFirePower() {
        return Math.min(Math.min(Math.max(this.getKillPower(this.e_energy), 0.1), this.getEnergy() - 0.2), Math.min(3.0, 3.0));
    }

    public boolean in(double x, double y) {
        return x > this.border && y > this.border && x < this.fieldX - this.border && y < this.fieldY - this.border;
    }

    public boolean inField(double x, double y) {
        return field.contains(x, y);
    }

    class Bullet {
        int distIndex;
        int relHeadIndex;
        int acclIndex;
        int speedIndex;
        double velocity;
        double absBear;
        double startX;
        double startY;
        double maxBearing;
        double fireTime;
        double[] spectra;

        Bullet() {
        }
    }
}

