/*
 * Decompiled with CFR 0.152.
 */
package rampancy_old.util;

import java.awt.geom.Point2D;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util {
    public static void setBackAsFront(AdvancedRobot robot, double goAngle, double dist) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(dist);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(dist);
        }
    }

    public static double computeDensity(List<Double> distances, double h) {
        double factor = 1.0 / ((double)distances.size() * h);
        double k_factor = 1.0 / Math.sqrt(Math.PI * 2);
        double sigma = 0.0;
        int i = 0;
        while (i < distances.size()) {
            sigma += Math.exp(-0.5 * Math.pow(distances.get(i) / h, 2.0));
            ++i;
        }
        return sigma * factor * k_factor;
    }

    public static double roundToPrecision(double value, int precision) {
        int temp = (int)Math.round(value * Math.max(1.0, Math.pow(10.0, precision)));
        return (double)temp / Math.pow(10.0, precision);
    }

    public static double scaleToRange(double min, double max, double minExpected, double maxExpected, double value) {
        return Util.scaleToRange(min, max, minExpected, maxExpected, value, 0.0);
    }

    public static double scaleToRange(double min, double max, double minExpected, double maxExpected, double value, double offset) {
        double scaleRange = max - min;
        double valueRange = maxExpected - minExpected;
        double percentDiff = scaleRange / valueRange;
        return Util.limit(min, (value + offset) * percentDiff, max);
    }

    public static boolean inRange(double min, double max, double value) {
        return value >= min && value <= max;
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static double lowest(double[] values) {
        double lowest = values[0];
        int i = 1;
        while (i < values.length) {
            if (lowest > values[i]) {
                lowest = values[i];
            }
            ++i;
        }
        return lowest;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double computeAbsoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double computeBulletVelocity(double bulletPower) {
        return 20.0 - 3.0 * bulletPower;
    }

    public static double computeMaxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static boolean isAdvancing(double absoluteBearing, double enemyHeading, double deltaHeading, double velocity) {
        if (Util.inRange(-0.07853981633974483, 0.07853981633974483, Math.abs(enemyHeading - absoluteBearing) - Math.PI)) {
            return Math.abs(deltaHeading) < 0.01 && velocity > 1.0;
        }
        return false;
    }

    public static int nonZeroSign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public static Point2D.Double project(Point2D.Double source, double angle, double length) {
        double x = source.x + Math.sin(angle) * length;
        double y = source.y + Math.cos(angle) * length;
        return new Point2D.Double(x, y);
    }
}

