/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.BasicMinimumRiscMovement;
import Krabb.sliNk.Data;
import Krabb.sliNk.DataHandling;
import Krabb.sliNk.Garm;
import Krabb.sliNk.WS1on1Movement;
import Krabb.sliNk.WSMeleeMovement;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

class Movement
extends Data {
    static BasicMinimumRiscMovement movement_1on1 = null;
    static BasicMinimumRiscMovement movement_melee = null;
    private double maxvelocity_next = 8.0;
    public double velocity_next = 0.0;
    public double heading_next = 0.0;
    public Point2D.Double position_next = null;
    public double velocity_current = 0.0;
    public double heading_current = 0.0;
    public double velocity_desired = 0.0;

    Movement() {
    }

    public void newRound() {
        super.newRound();
        movement_1on1 = new WS1on1Movement();
        movement_1on1.newRound(this);
        if (Garm.meleegame || Garm.teamgame) {
            movement_melee = new WSMeleeMovement();
            movement_melee.newRound(this);
        }
    }

    public void setMaxVelocity(double newMaxVelocity) {
        super.setMaxVelocity(newMaxVelocity);
        this.maxvelocity_next = newMaxVelocity = Math.min(Math.abs(newMaxVelocity), 8.0);
    }

    public void setBack(double v) {
        this.setAhead(-v);
    }

    public void setAhead(double v) {
        super.setAhead(v);
        this.velocity_current = this.getVelocity();
        this.velocity_desired = v;
        this.velocity_next = v;
        if (this.getEnergy() < 0.01) {
            if (this.getVelocity() == 0.0) {
                this.velocity_next = 0.0;
            } else {
                this.velocity_next = this.getVelocity() - 2.0 * DataHandling.mySignum(this.getVelocity());
                if (this.velocity_next * this.getVelocity() < 0.0) {
                    this.velocity_next = 0.0;
                }
            }
            return;
        }
        if (this.velocity_next == 0.0) {
            this.velocity_next = this.getVelocity() + 2.0 * DataHandling.mySignum(this.velocity_next - this.getVelocity());
            if (this.velocity_next * this.getVelocity() < 0.0 || this.getVelocity() == 0.0) {
                this.velocity_next = 0.0;
            }
        } else {
            this.velocity_next = this.getVelocity() > 0.0 && this.velocity_next < this.getVelocity() || this.getVelocity() < 0.0 && this.velocity_next > this.getVelocity() ? this.getVelocity() + 2.0 * DataHandling.mySignum(this.velocity_next - this.getVelocity()) : this.getVelocity() + DataHandling.mySignum(this.velocity_next - this.getVelocity());
        }
        if (this.velocity_next > 0.0) {
            this.velocity_next = Math.min(this.velocity_next, this.maxvelocity_next);
        } else if (this.velocity_next < 0.0) {
            this.velocity_next = Math.max(this.velocity_next, -this.maxvelocity_next);
        }
    }

    public void setTurnLeftRadians(double a) {
        this.setTurnRightRadians(-a);
    }

    public void setTurnRightRadians(double a) {
        super.setTurnRightRadians(a);
        this.heading_current = this.getHeadingRadians();
        if (this.getEnergy() < 0.01) {
            this.heading_next = this.getHeadingRadians();
            return;
        }
        double a_max = Math.toRadians(10.0 - 0.75 * Math.abs(this.getVelocity()));
        double a_new = a;
        a_new = a_new >= 0.0 ? Math.min(a_new, a_max) : Math.max(a_new, -a_max);
        this.heading_next = this.getHeadingRadians() + a_new;
    }

    public void calculateNextPosition() {
        this.position_next = DataHandling.project(Movement.stats_my.location, this.heading_next, this.velocity_next);
        if (Garm.field_rect_inner.contains(this.position_next)) {
            return;
        }
        boolean hitwall = false;
        double fixx = 0.0;
        double fixy = 0.0;
        if (this.position_next.x > Garm.field_rect_inner.x + Garm.field_rect_inner.width) {
            fixx = Garm.field_rect_inner.x + Garm.field_rect_inner.width - this.position_next.x;
            hitwall = true;
        } else if (this.position_next.x < Garm.field_rect_inner.x) {
            fixx = Garm.field_rect_inner.x - this.position_next.x;
            hitwall = true;
        } else if (this.position_next.y > Garm.field_rect_inner.y + Garm.field_rect_inner.height) {
            fixy = Garm.field_rect_inner.y + Garm.field_rect_inner.height - this.position_next.y;
            hitwall = true;
        } else if (this.position_next.y < Garm.field_rect_inner.y) {
            fixy = Garm.field_rect_inner.y - this.position_next.y;
            hitwall = true;
        }
        if (hitwall) {
            double velocity1 = 0.0;
            double velocity2 = 0.0;
            velocity1 = Math.abs(Math.sin(this.heading_next)) > 1.0E-5 && fixx != 0.0 ? fixx / Math.sin(this.heading_next) : 0.0;
            velocity2 = Math.abs(Math.cos(this.heading_next)) > 1.0E-5 && fixy != 0.0 ? fixy / Math.cos(this.heading_next) : 0.0;
            double fixv = 0.0;
            fixv = Math.max(Math.abs(velocity1), Math.abs(velocity2)) == Math.abs(velocity1) ? velocity1 : velocity2;
            double dx = fixv * Math.sin(this.heading_next);
            double dy = fixv * Math.cos(this.heading_next);
            if (Math.abs(dx) < Math.abs(fixx)) {
                dx = fixx;
            }
            if (Math.abs(dy) < Math.abs(fixy)) {
                dy = fixy;
            }
            this.position_next.x += dx;
            this.position_next.y += dy;
            this.velocity_next = 0.0;
        }
    }

    protected void step() {
        super.step();
        if (Garm.TC) {
            this.position_next = Movement.stats_my.location;
            this.velocity_next = this.getVelocity();
            this.heading_next = this.getHeading();
            return;
        }
        if (Garm.getLivingEnemies().size() <= 1) {
            movement_1on1.step(this);
        } else {
            movement_melee.step(this);
        }
    }

    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        if (Garm.meleegame || Garm.TC) {
            return;
        }
        if (Garm.getLivingEnemies().size() <= 1) {
            movement_1on1.onPaint(g, this);
        }
    }
}

