/*
 * Decompiled with CFR 0.152.
 */
package apvteam;

import java.io.Serializable;

public class infoContainer
implements Serializable {
    private double t;
    private double weight;
    private double x;
    private double y;
    private double v;
    private double av;
    private double w;
    private double h;
    private double e;
    private double ei;
    private String name;

    public void updateInfo(double time, double x, double y, double v, double h, double e) {
        if (time > this.t) {
            this.w = (h - this.h) / (time - this.t);
            this.t = time;
            this.x = x;
            this.y = y;
            this.h = h;
            this.v = v;
            this.av = this.av * 0.6 + v * 0.4;
            this.e = e;
        }
    }

    public double T() {
        return this.t;
    }

    public double weight() {
        if (this.weight != 0.0) {
            return this.weight;
        }
        return 1.0;
    }

    public double X() {
        return this.x;
    }

    public double Y() {
        return this.y;
    }

    public double X(double t) {
        return this.x + (t - this.t) * this.v * Math.sin(this.h);
    }

    public double Y(double t) {
        return this.y + (t - this.t) * this.v * Math.cos(this.h);
    }

    public double V() {
        return this.v;
    }

    public double AV() {
        return this.av;
    }

    public double W() {
        return this.w;
    }

    public double H() {
        return this.h;
    }

    public double E() {
        return this.e;
    }

    public double EI() {
        return this.ei;
    }

    public String name() {
        return this.name;
    }

    public double getB(double mex, double mey) {
        return Math.atan2(this.x - mex, this.y - mey);
    }

    public double getB(double t, double mex, double mey) {
        return Math.atan2(this.X(t) - mex, this.Y(t) - mey);
    }

    public boolean isPoint() {
        boolean bl = false;
        if (this.weight != 0.0) {
            bl = true;
        }
        return bl;
    }

    public infoContainer(double time, String name, double x, double y, double v, double h, double e) {
        this.t = time;
        this.name = name;
        this.x = x;
        this.y = y;
        this.h = h;
        this.v = v;
        this.av = v;
        this.w = 0.0;
        this.e = e;
        this.ei = e;
        this.weight = 0.0;
    }

    public infoContainer(double time, double x, double y, double v, double h, double weight, String target) {
        this.t = time;
        this.name = target;
        this.x = x;
        this.y = y;
        this.h = h;
        this.v = v;
        this.av = v;
        this.w = 0.0;
        this.ei = this.e = this.e;
        this.weight = weight;
    }
}

