/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rampancy.RWaveManager;
import rampancy.RampantRobot;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RUtil;
import rampancy.util.wave.RBulletWave;
import rampancy.util.wave.REnemyWave;
import rampancy.util.wave.REnemyWaveWithStats;
import rampancy.util.wave.RWave;
import robocode.Bullet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDefaultWaveManager
implements RWaveManager {
    protected ArrayList<REnemyWave> enemyWaves = new ArrayList();
    protected ArrayList<RBulletWave> bulletWaves = new ArrayList();
    protected RampantRobot reference;

    public RDefaultWaveManager(RampantRobot reference) {
        this.reference = reference;
    }

    @Override
    public void updateReference(RampantRobot reference) {
        this.reference = reference;
    }

    @Override
    public List<REnemyWave> getEnemyWaves() {
        return this.enemyWaves;
    }

    @Override
    public void update() {
        RWave wave;
        long time = this.reference.getTime();
        int i = this.enemyWaves.size() - 1;
        while (i >= 0) {
            wave = this.enemyWaves.get(i);
            wave.update(time);
            if (((REnemyWave)wave).didBreak(this.reference.getLocation())) {
                this.enemyWaves.remove(wave);
            }
            --i;
        }
        i = this.bulletWaves.size() - 1;
        while (i >= 0) {
            wave = this.bulletWaves.get(i);
            ((RBulletWave)wave).update(time);
            if (((RBulletWave)wave).didBreak()) {
                RampantRobot.getStatisticsManager().getTargetingStatistics().noteHitOnEnemy(((RBulletWave)wave).getTarget(), (RBulletWave)wave);
                RampantRobot.getTargetingManager().updateGuns((RBulletWave)wave);
                this.bulletWaves.remove(wave);
            }
            --i;
        }
    }

    @Override
    public void add(RWave wave) {
        if (wave instanceof REnemyWave) {
            this.enemyWaves.add((REnemyWave)wave);
        }
        if (wave instanceof RBulletWave) {
            this.bulletWaves.add((RBulletWave)wave);
        }
    }

    @Override
    public REnemyWave getClosestEnemyWave() {
        RPoint location = this.reference.getCopyOfLocation();
        return this.getClosestEnemyWave(location);
    }

    @Override
    public REnemyWave getClosestEnemyWave(RPoint location) {
        double closest = 500000.0;
        REnemyWave closestWave = null;
        for (REnemyWave wave : this.enemyWaves) {
            double time = wave.timeToImpact(location);
            if (!(time < closest)) continue;
            closest = time;
            closestWave = wave;
        }
        return closestWave;
    }

    public REnemyWave getNthClosestEnemyWave(final RPoint location, int n) {
        if (n > this.enemyWaves.size()) {
            return null;
        }
        ArrayList<REnemyWave> tempWaves = new ArrayList<REnemyWave>(this.enemyWaves);
        Collections.sort(tempWaves, new Comparator<REnemyWave>(){

            @Override
            public int compare(REnemyWave o1, REnemyWave o2) {
                return RUtil.sign(o1.timeToImpact(location) - o2.timeToImpact(location));
            }
        });
        return tempWaves.get(n - 1);
    }

    @Override
    public REnemyWave getWaveForEnemyBullet(Bullet bullet) {
        RPoint referenceLocation = this.reference.getCopyOfLocation();
        REnemyWave hitWave = null;
        for (REnemyWave wave : this.enemyWaves) {
            if (!(Math.abs(wave.getDistanceTraveled() - referenceLocation.distance(wave.getOrigin())) < 50.0) || Math.round(RUtil.computeBulletVelocity(bullet.getPower()) * 10.0) != Math.round(wave.getVelocity() * 10.0)) continue;
            hitWave = wave;
            break;
        }
        return hitWave;
    }

    @Override
    public RWave getClosestWave() {
        RPoint location = this.reference.getCopyOfLocation();
        return this.getClosestWave(location);
    }

    @Override
    public RWave getClosestWave(RPoint location) {
        double closest = 500000.0;
        RWave closestWave = null;
        for (RWave rWave : this.bulletWaves) {
            double time = rWave.timeToImpact(location);
            if (!(time < closest)) continue;
            closest = time;
            closestWave = rWave;
        }
        return closestWave;
    }

    @Override
    public RBulletWave getWaveForBullet(Bullet bullet) {
        double closest = 50000.0;
        RBulletWave closestWave = null;
        for (RBulletWave wave : this.bulletWaves) {
            double time = wave.timeToImpact(new RPoint(bullet.getX(), bullet.getY()));
            if (!(time < closest)) continue;
            closest = time;
            closestWave = wave;
        }
        return closestWave;
    }

    @Override
    public void clearWaves() {
        this.enemyWaves.clear();
        this.bulletWaves.clear();
    }

    @Override
    public void shotFired(REnemyRobot enemy) {
        this.add(new REnemyWaveWithStats(enemy));
        this.removeVirtualEnemyWaves();
    }

    @Override
    public void enemyUpdated(REnemyRobot enemy) {
    }

    @Override
    public void draw(Graphics2D g) {
        for (REnemyWave rEnemyWave : this.enemyWaves) {
            rEnemyWave.draw(g);
        }
        for (RBulletWave rBulletWave : this.bulletWaves) {
            rBulletWave.draw(g);
        }
    }

    private void removeVirtualEnemyWaves() {
        int i = this.enemyWaves.size() - 1;
        while (i >= 0) {
            if (this.enemyWaves.get(i).isVirtual()) {
                this.enemyWaves.remove(i);
            }
            --i;
        }
    }
}

