/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util;

import rampancy.RampantRobot;
import rampancy.util.RDistanceFunction;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RUtil;
import rampancy.util.data.segmentArray.RSegmentFunction;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RRobotState {
    public RPoint location;
    public double absoluteBearing;
    public double velocity;
    public double lateralVelocity;
    public double advancingVelocity;
    public double deltaV;
    public double heading;
    public double deltaH;
    public double distance;
    public double distanceFromWall;
    public int distanceFromWallCategory;
    public double timeSinceVelocityChange;
    public double timeSinceDirectionChange;
    public double timeSinceStop;
    public double energy;
    public double gunHeat;
    public boolean accelerating;
    public boolean breaking;
    public int directionTraveling;
    public static final RDistanceFunction<RRobotState> DELTA_H_DISTANCE_FUNCTION = new RDistanceFunction<RRobotState>(){

        @Override
        public double distance(RRobotState o1, RRobotState o2) {
            return 0.0;
        }
    };
    public static final RSegmentFunction DISTANCE_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 1200.0, state.distance);
        }
    };
    public static final RSegmentFunction DISTANCE_FROM_WALL_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return RampantRobot.getGlobalBattlefield().distanceFromWallCategory(state.location);
        }
    };
    public static final RSegmentFunction VELOCITY_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.velocity, segmentSize / 2);
        }
    };
    public static final RSegmentFunction LATERAL_VELOCITY_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.lateralVelocity, segmentSize / 2);
        }
    };
    public static final RSegmentFunction ADVANCING_VELOCITY_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.advancingVelocity, segmentSize / 2);
        }
    };
    public static final RSegmentFunction DELTA_V_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.deltaV, segmentSize / 2);
        }
    };
    public static final RSegmentFunction ABSOLUTE_BEARING_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, Math.PI * 2, state.absoluteBearing);
        }
    };
    public static final RSegmentFunction HEADNG_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, Math.PI * 2, state.heading);
        }
    };
    public static final RSegmentFunction DELTA_H_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, Math.PI, state.deltaH, segmentSize / 2);
        }
    };
    public static final RSegmentFunction TIME_SINCE_VELOCITY_CHANGE_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 1000.0, state.timeSinceVelocityChange);
        }
    };
    public static final RSegmentFunction TIME_SINCE_DIRECTION_CHANGE_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 1000.0, state.timeSinceDirectionChange);
        }
    };
    public static final RSegmentFunction TIME_SINCE_STOP_SEGMENT_FUCNTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 1000.0, state.timeSinceStop);
        }
    };
    public static final RSegmentFunction ACCELERATING_OR_BREAKING_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            if (state.breaking) {
                return 0;
            }
            if (state.accelerating) {
                return 1;
            }
            return 2;
        }
    };
    public static final RSegmentFunction DIRECTION_TRAVELING_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return 1 + state.directionTraveling;
        }
    };

    public RRobotState() {
    }

    public RRobotState(RampantRobot robot, ScannedRobotEvent e) {
        RRobotState lastState = robot.getCurrentState();
        double enemyAbsoluteBearing = e == null ? 0.0 : Utils.normalAbsoluteAngle((double)(robot.getHeadingRadians() + e.getBearingRadians()));
        double enemyDistance = e == null ? 100.0 : e.getDistance();
        this.location = new RPoint(robot.getX(), robot.getY());
        RPoint enemyLocation = RUtil.project(this.location, enemyAbsoluteBearing, enemyDistance);
        this.absoluteBearing = RUtil.computeAbsoluteBearing(enemyLocation, this.location);
        this.heading = robot.getHeadingRadians();
        this.velocity = robot.getVelocity();
        this.lateralVelocity = this.velocity * Math.sin(this.heading - this.absoluteBearing);
        this.advancingVelocity = 0.0;
        this.deltaV = lastState == null ? 0.0 : this.velocity - lastState.velocity;
        this.accelerating = this.deltaV > 0.0;
        this.breaking = !this.accelerating;
        this.deltaH = lastState == null ? 0.0 : this.heading - lastState.heading;
        this.distance = 0.0;
        this.distanceFromWall = RUtil.getDistanceFromWall(this.location);
        this.distanceFromWallCategory = RampantRobot.getGlobalBattlefield().distanceFromWallCategory(this.location);
        this.timeSinceVelocityChange = this.deltaV != 0.0 || lastState == null ? 0.0 : lastState.timeSinceVelocityChange + 1.0;
        this.directionTraveling = this.lateralVelocity >= 0.0 ? 1 : -1;
        this.timeSinceDirectionChange = lastState == null || lastState.directionTraveling != this.directionTraveling ? 0.0 : lastState.timeSinceDirectionChange + 1.0;
        this.timeSinceStop = this.velocity == 0.0 || lastState == null ? 0.0 : lastState.timeSinceStop + 1.0;
        this.energy = robot.getEnergy();
    }

    public RRobotState(REnemyRobot robot, ScannedRobotEvent e) {
        RampantRobot reference = robot.getReference();
        if (reference == null) {
            return;
        }
        RRobotState lastState = robot.getCurrentState();
        this.heading = e.getHeadingRadians();
        this.absoluteBearing = Utils.normalAbsoluteAngle((double)(reference.getHeadingRadians() + e.getBearingRadians()));
        this.location = RUtil.project(reference.getLocation(), this.absoluteBearing, e.getDistance());
        this.velocity = e.getVelocity();
        this.lateralVelocity = this.velocity * Math.sin(this.heading - this.absoluteBearing);
        this.advancingVelocity = this.velocity * -1.0 * Math.cos(this.heading - this.absoluteBearing);
        this.deltaV = lastState == null ? 0.0 : this.velocity - lastState.velocity;
        this.accelerating = this.deltaV > 0.0;
        this.breaking = !this.accelerating;
        this.deltaH = lastState == null ? 0.0 : this.heading - lastState.heading;
        this.distance = e.getDistance();
        this.distanceFromWall = RUtil.getDistanceFromWall(this.location);
        this.distanceFromWallCategory = RampantRobot.getGlobalBattlefield().distanceFromWallCategory(this.location);
        this.timeSinceVelocityChange = this.deltaV != 0.0 || lastState == null ? 0.0 : lastState.timeSinceVelocityChange + 1.0;
        this.directionTraveling = this.lateralVelocity >= 0.0 ? 1 : -1;
        this.timeSinceDirectionChange = lastState == null || lastState.directionTraveling != this.directionTraveling ? 0.0 : lastState.timeSinceDirectionChange + 1.0;
        this.timeSinceStop = this.velocity == 0.0 || lastState == null ? 0.0 : lastState.timeSinceStop + 1.0;
        this.energy = e.getEnergy();
    }

    public RRobotState(RPoint location, double absoluteBearing, double velocity, double lateralVelocity, double advancingVelocity, double deltaV, double heading, double deltaH, double distance, double distanceFromWall, double timeSinceVelocityChange, double timeSinceDirectionChange, double timeSinceStop, double energy, int directionTraveling) {
        this.location = location.getCopy();
        this.absoluteBearing = absoluteBearing;
        this.velocity = velocity;
        this.lateralVelocity = lateralVelocity;
        this.advancingVelocity = advancingVelocity;
        this.deltaV = deltaV;
        this.heading = heading;
        this.deltaH = deltaH;
        this.distance = distance;
        this.distanceFromWall = distanceFromWall;
        this.timeSinceVelocityChange = timeSinceVelocityChange;
        this.timeSinceDirectionChange = timeSinceDirectionChange;
        this.timeSinceStop = timeSinceStop;
        this.energy = energy;
        this.directionTraveling = directionTraveling;
        this.accelerating = deltaV > 0.0;
        this.breaking = deltaV < 0.0;
    }

    public RRobotState(RRobotState state) {
        this(state.location, state.absoluteBearing, state.velocity, state.lateralVelocity, state.advancingVelocity, state.deltaV, state.heading, state.deltaH, state.distance, state.distanceFromWall, state.timeSinceVelocityChange, state.timeSinceDirectionChange, state.timeSinceStop, state.energy, state.directionTraveling);
    }

    public RRobotState getCopy() {
        return new RRobotState(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.absoluteBearing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.accelerating ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.advancingVelocity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.breaking ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.deltaH);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.deltaV);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.directionTraveling;
        temp = Double.doubleToLongBits(this.distance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.distanceFromWall);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.distanceFromWallCategory;
        temp = Double.doubleToLongBits(this.energy);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.gunHeat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.heading);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lateralVelocity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        temp = Double.doubleToLongBits(this.timeSinceDirectionChange);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.timeSinceStop);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.timeSinceVelocityChange);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.velocity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RRobotState other = (RRobotState)obj;
        if (Double.doubleToLongBits(this.absoluteBearing) != Double.doubleToLongBits(other.absoluteBearing)) {
            return false;
        }
        if (this.accelerating != other.accelerating) {
            return false;
        }
        if (Double.doubleToLongBits(this.advancingVelocity) != Double.doubleToLongBits(other.advancingVelocity)) {
            return false;
        }
        if (this.breaking != other.breaking) {
            return false;
        }
        if (Double.doubleToLongBits(this.deltaH) != Double.doubleToLongBits(other.deltaH)) {
            return false;
        }
        if (Double.doubleToLongBits(this.deltaV) != Double.doubleToLongBits(other.deltaV)) {
            return false;
        }
        if (this.directionTraveling != other.directionTraveling) {
            return false;
        }
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distanceFromWall) != Double.doubleToLongBits(other.distanceFromWall)) {
            return false;
        }
        if (this.distanceFromWallCategory != other.distanceFromWallCategory) {
            return false;
        }
        if (Double.doubleToLongBits(this.energy) != Double.doubleToLongBits(other.energy)) {
            return false;
        }
        if (Double.doubleToLongBits(this.gunHeat) != Double.doubleToLongBits(other.gunHeat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.heading) != Double.doubleToLongBits(other.heading)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lateralVelocity) != Double.doubleToLongBits(other.lateralVelocity)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (Double.doubleToLongBits(this.timeSinceDirectionChange) != Double.doubleToLongBits(other.timeSinceDirectionChange)) {
            return false;
        }
        if (Double.doubleToLongBits(this.timeSinceStop) != Double.doubleToLongBits(other.timeSinceStop)) {
            return false;
        }
        if (Double.doubleToLongBits(this.timeSinceVelocityChange) != Double.doubleToLongBits(other.timeSinceVelocityChange)) {
            return false;
        }
        return Double.doubleToLongBits(this.velocity) == Double.doubleToLongBits(other.velocity);
    }
}

