/*
 * Decompiled with CFR 0.152.
 */
package pulsar.gf;

import pulsar.gf.Segmentation;
import pulsar.util.RobotData;

public class DistanceSegmentation
extends Segmentation {
    private static final double[] distanceSegMedium2 = new double[]{200, 400, 600, 800};
    private static final double[] distanceSegLow = new double[]{250, 500, 750};
    private static final double[] distanceSegMedium = new double[]{180, 360, 540, 720};
    public static final int MEDIUM2_SEGMENTATION = 2;

    public DistanceSegmentation() {
        this(1);
    }

    public DistanceSegmentation(int segmentation) {
        switch (segmentation) {
            case 0: {
                this.setLimits(distanceSegLow);
                break;
            }
            case 1: {
                this.setLimits(distanceSegMedium);
                break;
            }
            case 2: {
                this.setLimits(distanceSegMedium2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid segmentation: " + segmentation);
            }
        }
    }

    protected double getValue(RobotData firedFrom, RobotData firedAt, int stepsBack) {
        return firedFrom.getDistanceTo(firedAt, stepsBack);
    }
}

