/*
 * Decompiled with CFR 0.152.
 */
package xander.core.paint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import xander.core.event.Painter;

public abstract class GraphPainter
implements Painter {
    private double[] dataPoints;
    private double maxValue;
    private int startIndex;
    private int lastIndex;
    private Point2D.Double position;
    private Color color;

    public GraphPainter(Point2D.Double position, Color color, int numDataPoints) {
        this.position = position;
        this.color = color;
        this.dataPoints = new double[numDataPoints];
        this.lastIndex = numDataPoints - 1;
    }

    public GraphPainter(Color color, int numDataPoints) {
        this(new Point2D.Double(0.0, 0.0), color, numDataPoints);
    }

    protected abstract String getPointLabel(double var1);

    protected void rollStartIndex() {
        ++this.startIndex;
        ++this.lastIndex;
        if (this.startIndex >= this.dataPoints.length) {
            this.startIndex = 0;
        }
        if (this.lastIndex >= this.dataPoints.length) {
            this.lastIndex = 0;
        }
    }

    protected void setDataPoint(int index, double value) {
        this.dataPoints[index] = value;
        if (value > this.maxValue) {
            this.maxValue = value;
        }
    }

    protected void setRolledDataPoint(double value) {
        this.setDataPoint(this.lastIndex, value);
    }

    public void setPosition(double x, double y) {
        this.position.x = x;
        this.position.y = y;
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(Color.GRAY);
        g.draw(new Line2D.Double(this.position.x, this.position.y, this.position.x + (double)this.dataPoints.length, this.position.y));
        g.draw(new Line2D.Double(this.position.x, this.position.y, this.position.x, this.position.y + 100.0));
        g.setColor(this.color);
        double x = this.position.x;
        double y = this.position.y;
        if (this.maxValue > 0.0) {
            Path2D.Double uPath = new Path2D.Double();
            int ttIdx = this.startIndex;
            int i = 0;
            while (i < this.dataPoints.length) {
                if (i == 0) {
                    uPath.moveTo(x, y + 100.0 * this.dataPoints[ttIdx] / this.maxValue);
                } else {
                    uPath.lineTo(x, y + 100.0 * this.dataPoints[ttIdx] / this.maxValue);
                }
                if (++ttIdx >= this.dataPoints.length) {
                    ttIdx = 0;
                }
                x += 1.0;
                ++i;
            }
            g.draw(uPath);
        }
        g.drawString(this.getPointLabel(this.maxValue), (float)(this.position.x + (double)this.dataPoints.length), (float)y + 90.0f);
    }
}

