/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pedersen.physics.StaticPosition;
import pedersen.physics.Wave;

public class Conversions {
    public static final double maxAbsVehicularTurnRate = 0.17453292519943295;
    public static final double vehicularTurnRateScalar = 0.01308996938995747;

    public static double getBulletDamageFromFirepower(double firepower) {
        return Math.max(firepower * 4.0, firepower * 4.0 + (firepower - 1.0) * 2.0);
    }

    public static double getBulletVelocityFromFirepower(double firepower) {
        return 20.0 - 3.0 * firepower;
    }

    public static double getFirepowerFromBulletVelocity(double velocity) {
        return (20.0 - velocity) / 3.0;
    }

    public static double getAbsMaxTurnRateFromVelocity(double velocity) {
        return 0.17453292519943295 - 0.01308996938995747 * Math.abs(velocity);
    }

    public static double getAbsVelocityFromMaxTurnRate(double turnRate) {
        return (0.17453292519943295 - Math.abs(turnRate)) / 0.01308996938995747;
    }

    public static double getEnergyRewardFromFirepower(double firepower) {
        return 3.0 * firepower;
    }

    public static double getFirepowerFromEnergyReward(double energy) {
        return energy / 3.0;
    }

    public static Rectangle2D.Double getRectangle2DForRobot(StaticPosition center) {
        return new Rectangle2D.Double(center.getX() - 18.0, center.getY() - 18.0, 36.0, 36.0);
    }

    public static Line2D.Double getLine2D(StaticPosition a, StaticPosition b) {
        return new Line2D.Double(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public static Point2D.Double getPoint2D(StaticPosition position) {
        return new Point2D.Double(position.getX(), position.getY());
    }

    public static Ellipse2D.Double getEllipse2DForWave(Wave wave, long time) {
        double radius = wave.getRadius(time);
        return new Ellipse2D.Double(wave.getX() - radius, wave.getY() - radius, radius + radius, radius + radius);
    }

    public static double degreesToRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }
}

