/*
 * Decompiled with CFR 0.152.
 */
package muf;

import java.awt.Color;
import java.awt.geom.Point2D;
import muf.utils.AdvancedTargetingsEvaluator;
import muf.utils.AveragedCircularTargeting;
import muf.utils.CircularTargeting;
import muf.utils.DodgerStatisticalTargeting;
import muf.utils.GameData;
import muf.utils.GameDataBuffer;
import muf.utils.HalfedCircularTargeting;
import muf.utils.HeadOnTargeting;
import muf.utils.IndexMaker;
import muf.utils.LinearIndexMaker;
import muf.utils.Rutils;
import muf.utils.Targeting;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.WinEvent;

public class CrazyKitten
extends AdvancedRobot {
    protected static final double maxEnemyDistance = 600.0;
    protected static final double minEnemyDistance = 400.0;
    protected static final double distanceChange = 25.0;
    protected static final double minDeltaTurnAngle = 10.0;
    protected static final double maxDeltaTurnAngle = 30.0;
    protected static final double minDeltaTurnAngleEscape = 30.0;
    protected static final double maxDeltaTurnAngleEscape = 60.0;
    protected static final int maxN = 30;
    protected static final int initTimeToMove = 32;
    protected static boolean firstRound = true;
    protected static double bfw;
    protected static double bfh;
    protected static IndexMaker dodgerStatDistanceIM;
    protected static IndexMaker dodgerStatHeadingIM;
    protected static IndexMaker dodgerStatVelocityIM;
    protected static IndexMaker bulletPowerIM;
    protected static IndexMaker targetingAngleIM;
    protected static IndexMaker evaluatorDistanceIM;
    protected static GameData prevGameData;
    protected static GameData gameData;
    protected static GameDataBuffer gameDataBuffer;
    protected static Targeting[] targetings;
    protected static AdvancedTargetingsEvaluator targetingsEvaluator;
    protected int timeToMove = 32;
    protected int moveDirection = 1;
    protected int changeDirBlock = 0;
    protected double desiredEnemyDistance = 500.0;
    protected double deltaTurnAngle = 30.0;
    protected double firePower;
    protected double lastShotPredictedX;
    protected double lastShotPredictedY;
    protected double lastShotAngle;
    protected GameData lastShotGameData = null;
    protected long lastWallNear = 0L;
    protected long lastDoubleWallNear = 0L;
    protected long lastEnemyShot = 0L;
    protected boolean directionChanged = true;
    protected boolean aimed = false;
    protected boolean enemyFired = false;

    protected void init() {
        this.setColors(new Color(255, 255, 70), new Color(255, 100, 100), new Color(255, 255, 255));
        bfw = this.getBattleFieldWidth();
        bfh = this.getBattleFieldHeight();
        double maxDistance = Math.sqrt(bfw * bfw + bfh * bfh);
        bulletPowerIM = new LinearIndexMaker(0.25, 3.25, 2);
        targetingAngleIM = new LinearIndexMaker(-60.0, 60.0, 29);
        dodgerStatDistanceIM = new LinearIndexMaker(0.0, 900.0, 2);
        dodgerStatHeadingIM = new LinearIndexMaker(-180.0, 180.0, 5);
        dodgerStatVelocityIM = new LinearIndexMaker(-8.0, 8.0, 2);
        prevGameData = new GameData();
        gameData = new GameData();
        gameDataBuffer = new GameDataBuffer((int)(700.0 / Rutils.BulletMinVelocity));
        int index = 0;
        targetings = new Targeting[5];
        CrazyKitten.targetings[index++] = new HeadOnTargeting(gameData);
        CrazyKitten.targetings[index++] = new CircularTargeting(gameData, gameDataBuffer, bfw, bfh);
        CrazyKitten.targetings[index++] = new HalfedCircularTargeting(gameData, gameDataBuffer, bfw, bfh);
        CrazyKitten.targetings[index++] = new AveragedCircularTargeting(gameData, bfw, bfh, 30);
        CrazyKitten.targetings[index++] = new DodgerStatisticalTargeting(gameData, gameDataBuffer, bfw, bfh, 0, dodgerStatDistanceIM, dodgerStatHeadingIM, dodgerStatVelocityIM, bulletPowerIM, targetingAngleIM);
        evaluatorDistanceIM = new LinearIndexMaker(0.0, 600.0, 2);
        targetingsEvaluator = new AdvancedTargetingsEvaluator(targetings, gameData, evaluatorDistanceIM, bulletPowerIM, 30);
    }

    public void run() {
        if (firstRound) {
            this.init();
            firstRound = false;
        }
        CrazyKitten.prevGameData.empty = true;
        CrazyKitten.gameData.empty = true;
        gameDataBuffer.delAll();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        while (CrazyKitten.gameData.empty) {
            this.execute();
        }
        while (true) {
            boolean movingAhead;
            if (this.getTime() - CrazyKitten.gameData.time > 8L) {
                this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            }
            if (CrazyKitten.gameData.time - this.lastEnemyShot > 50L && (CrazyKitten.gameData.enemyEnergy == 0.0 || CrazyKitten.gameData.enemyEnergy <= Rutils.BulletMinDamage && CrazyKitten.gameData.myEnergy >= 10.0)) {
                this.ram();
            }
            if (this.getWallDistance() < 100.0) {
                this.directionChanged = true;
                this.moveDirection *= -1;
                this.changeDirBlock = 2;
                if (this.getTime() - this.lastWallNear < 50L) {
                    this.desiredEnemyDistance = Math.min(this.desiredEnemyDistance, CrazyKitten.gameData.enemyDistance - 25.0);
                    this.lastDoubleWallNear = this.getTime();
                }
                this.lastWallNear = this.getTime();
            }
            if (CrazyKitten.gameData.time - this.lastEnemyShot > 50L && CrazyKitten.gameData.enemyEnergy <= 3.0 && CrazyKitten.gameData.myEnergy >= 10.0) {
                this.desiredEnemyDistance = Math.min(this.desiredEnemyDistance, 150.0);
            }
            if (this.directionChanged) {
                this.setAhead(Double.POSITIVE_INFINITY * (double)this.moveDirection);
                this.directionChanged = false;
            }
            double perpendAngle = CrazyKitten.gameData.enemyBearing + 90.0;
            boolean needCloser = CrazyKitten.gameData.enemyDistance > this.desiredEnemyDistance;
            boolean bl = movingAhead = this.moveDirection == 1;
            if (needCloser && movingAhead || !needCloser && !movingAhead) {
                this.setTurnRight(perpendAngle - this.deltaTurnAngle);
            } else {
                this.setTurnRight(perpendAngle + this.deltaTurnAngle);
            }
            this.enemyFired = false;
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double radarBearing;
        double energyDiff;
        if (!CrazyKitten.gameData.empty) {
            prevGameData = new GameData(gameData);
        }
        gameData.update(this.getTime(), this.getX(), this.getY(), this.getHeading(), this.getGunHeading(), this.getEnergy(), this.getVelocity(), e.getBearing(), e.getDistance(), e.getHeading(), e.getEnergy(), e.getVelocity());
        gameDataBuffer.add(new GameData(gameData));
        targetingsEvaluator.notifyEnemyScanned();
        if (!CrazyKitten.prevGameData.empty && 0.1 <= (energyDiff = CrazyKitten.prevGameData.enemyEnergy - CrazyKitten.gameData.enemyEnergy) && energyDiff <= 3.0) {
            this.enemyFired = true;
            this.lastEnemyShot = CrazyKitten.gameData.time;
        }
        double radarTurnDir = (radarBearing = Rutils.angleDiff(CrazyKitten.gameData.enemyAbsBearing, this.getRadarHeading())) > 0.0 ? 1.0 : -1.0;
        double radarTurnAngle = Math.abs(radarBearing) + 22.0;
        if (radarTurnDir == 1.0) {
            this.setTurnRadarRight(radarTurnAngle);
        } else {
            this.setTurnRadarLeft(radarTurnAngle);
        }
        if (this.enemyFired || this.timeToMove <= 0) {
            double velocity;
            this.timeToMove = 32;
            if (Math.random() < 0.25 && this.changeDirBlock <= 0) {
                this.directionChanged = true;
                this.moveDirection *= -1;
                if (CrazyKitten.gameData.time - this.lastDoubleWallNear > 100L) {
                    this.desiredEnemyDistance = Rutils.random(400.0, 600.0);
                }
            } else {
                --this.changeDirBlock;
            }
            if ((velocity = Rutils.random(0.0, 16.0)) > 8.0) {
                velocity = 8.0;
            }
            this.deltaTurnAngle = Rutils.random(10.0, 30.0);
            if (CrazyKitten.gameData.enemyDistance < this.desiredEnemyDistance * 0.75) {
                this.deltaTurnAngle = Rutils.random(30.0, 60.0);
                this.changeDirBlock = 2;
                velocity = 8.0;
            }
            this.setMaxVelocity(velocity);
        } else {
            --this.timeToMove;
        }
        if (this.getGunHeat() > 0.1) {
            double ticksToFire = this.getGunHeat() / this.getGunCoolingRate();
            double gunBearing = Rutils.angleDiff(CrazyKitten.gameData.enemyAbsBearing, CrazyKitten.gameData.myGunHeading);
            if (Math.abs(gunBearing) / 20.0 > ticksToFire - 1.0) {
                this.setTurnGunRight(gunBearing);
            }
        } else {
            if (!this.aimed) {
                this.aim();
                this.aimed = true;
            }
            if (this.getGunTurnRemaining() == 0.0) {
                if ((CrazyKitten.gameData.myEnergy > 3.0 || CrazyKitten.gameData.enemyDistance < 100.0) && this.firePower > 0.0 && this.getGunHeat() == 0.0) {
                    this.setFire(this.firePower);
                    CrazyKitten.gameData.firedBulletPower = this.firePower;
                    targetingsEvaluator.virtualFire(this.firePower);
                }
                this.aimed = false;
            }
        }
        targetingsEvaluator.evaluateBullets();
    }

    public void onHitWall(HitWallEvent e) {
        this.moveDirection *= -1;
        this.directionChanged = true;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.moveDirection *= -1;
        this.directionChanged = true;
    }

    protected void aim() {
        this.setFirePower();
        Targeting bestTargeting = targetingsEvaluator.getBestTargeting(CrazyKitten.gameData.enemyDistance, this.firePower);
        double bestAngle = bestTargeting.getTurnGunRightAngle(this.firePower);
        this.setTurnGunRight(bestAngle);
        targetingsEvaluator.virtualAim(this.firePower);
        this.lastShotAngle = bestTargeting.getAbsAngle(this.firePower);
        this.lastShotGameData = new GameData(gameData);
        this.lastShotGameData.firedBulletPower = this.firePower;
        this.lastShotPredictedX = CrazyKitten.gameData.myX + CrazyKitten.gameData.enemyDistance * Rutils.sin(this.lastShotAngle);
        this.lastShotPredictedY = CrazyKitten.gameData.myY + CrazyKitten.gameData.enemyDistance * Rutils.cos(this.lastShotAngle);
    }

    protected void setFirePower() {
        double multiShotFirePower = 3.0;
        if (this.lastShotGameData != null) {
            double bulletVelocity = Rutils.bulletVelocity(this.lastShotGameData.firedBulletPower);
            double bulletTravelTime = this.lastShotGameData.enemyDistance / bulletVelocity;
            double timeDiff = CrazyKitten.gameData.time - this.lastShotGameData.time;
            double bulletTravelTimeLeft = bulletTravelTime - timeDiff;
            double distanceToPredictedPos = Point2D.Double.distance(CrazyKitten.gameData.myX, CrazyKitten.gameData.myY, this.lastShotPredictedX, this.lastShotPredictedY);
            double velocityNeeded = distanceToPredictedPos / bulletTravelTimeLeft;
            double bulletPower = Rutils.bulletPowerFromVelocity(velocityNeeded);
            if (0.1 <= bulletPower && bulletPower <= 3.0) {
                multiShotFirePower = bulletPower;
            }
        }
        this.firePower = Math.min(Rutils.bulletPower(CrazyKitten.gameData.enemyEnergy - 0.1), multiShotFirePower);
    }

    protected void ram() {
        this.setMaxVelocity(8.0);
        do {
            this.setAhead(CrazyKitten.gameData.enemyDistance + 30.0);
            this.setTurnRight(CrazyKitten.gameData.enemyBearing);
            this.execute();
        } while (this.getDistanceRemaining() != 0.0);
    }

    protected double getRealHeading() {
        if (this.moveDirection == 1) {
            return this.getHeading();
        }
        return Rutils.normalAbsoluteAngle(this.getHeading() + 180.0);
    }

    protected double getWallDistance(double heading, double x, double y) {
        double deltaY;
        double deltaX;
        double xAngle;
        double yAngle;
        double xSize = this.getBattleFieldWidth();
        double ySize = this.getBattleFieldHeight();
        double absHeading = Rutils.normalAbsoluteAngle(heading);
        if (0.0 <= absHeading && absHeading < 90.0) {
            yAngle = absHeading;
            xAngle = 90.0 - absHeading;
            deltaX = xSize - x;
            deltaY = ySize - y;
        } else if (90.0 <= absHeading && absHeading < 180.0) {
            yAngle = 180.0 - absHeading;
            xAngle = absHeading - 90.0;
            deltaX = xSize - x;
            deltaY = y;
        } else if (180.0 <= absHeading && absHeading < 270.0) {
            yAngle = absHeading - 180.0;
            xAngle = 270.0 - absHeading;
            deltaX = x;
            deltaY = y;
        } else {
            yAngle = 360.0 - absHeading;
            xAngle = absHeading - 270.0;
            deltaX = x;
            deltaY = ySize - y;
        }
        double xAngleRad = Math.toRadians(xAngle);
        double yAngleRad = Math.toRadians(yAngle);
        double xDistance = deltaX / Math.cos(xAngleRad);
        double yDistance = deltaY / Math.cos(yAngleRad);
        return Math.abs(Math.min(xDistance, yDistance));
    }

    protected double getWallDistance() {
        return this.getWallDistance(this.getRealHeading(), this.getX(), this.getY());
    }

    public void onWin(WinEvent e) {
        this.setStop();
        this.setTurnRadarLeft(Rutils.normalRelativeAngle(this.getRadarHeading()));
        this.setTurnGunLeft(Rutils.normalRelativeAngle(this.getGunHeading()));
        this.setTurnLeft(Rutils.normalRelativeAngle(this.getHeading()));
        this.waitFor((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
        this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        int turnDir = 1;
        int i = 0;
        while (i < 9) {
            if (turnDir == 1) {
                this.setTurnRadarRight(360.0);
                this.setTurnGunLeft(180.0);
                this.turnRight(90.0);
                turnDir = -1;
            } else {
                this.setTurnRadarLeft(360.0);
                this.setTurnGunRight(180.0);
                this.turnLeft(90.0);
                turnDir = 1;
            }
            ++i;
        }
        while (true) {
            this.doNothing();
        }
    }
}

