/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import java.awt.geom.Point2D;
import muf.utils.CircularTargeting;
import muf.utils.GameData;
import muf.utils.GameDataBuffer;
import muf.utils.Rutils;

public class HalfedCircularTargeting
extends CircularTargeting {
    public HalfedCircularTargeting(GameData gameData, GameDataBuffer gameDataBuffer, double d, double d2) {
        super(gameData, gameDataBuffer, d, d2);
        this.name = new String("HalfedCircularTargeting");
    }

    public double getAbsAngle(double d) {
        this.gameDataBuffer.reset();
        this.gameDataBuffer.getPrev();
        if (!this.gameDataBuffer.hasPrev()) {
            return this.gameData.enemyAbsBearing;
        }
        GameData gameData = this.gameDataBuffer.getPrev();
        double d2 = (this.gameData.enemyHeading - gameData.enemyHeading) / (double)(this.gameData.time - gameData.time);
        double d3 = Rutils.bulletVelocity(d);
        int n = 0;
        double d4 = this.gameData.enemyX;
        double d5 = this.gameData.enemyY;
        while ((double)n++ * d3 < Point2D.Double.distance(this.gameData.myX, this.gameData.myY, d4, d5)) {
            d4 += Rutils.sin(this.gameData.enemyHeading + (double)n * d2) * this.gameData.enemyVelocity / 2.0;
            d5 += Rutils.cos(this.gameData.enemyHeading + (double)n * d2) * this.gameData.enemyVelocity / 2.0;
            d4 = Math.min(Math.max(18.0, d4), this.xSize - 18.0);
            d5 = Math.min(Math.max(18.0, d5), this.ySize - 18.0);
        }
        return Rutils.atan2(d4 - this.gameData.myX, d5 - this.gameData.myY);
    }
}

