/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import java.awt.geom.Point2D;
import muf.utils.Rutils;

public class VirtualBullet {
    protected int ID;
    protected long startTime;
    protected double startX;
    protected double startY;
    protected double velocity;
    protected double angle;

    public VirtualBullet(int n, long l, double d, double d2, double d3, double d4) {
        this.ID = n;
        this.startTime = l;
        this.startX = d;
        this.startY = d2;
        this.velocity = Rutils.bulletVelocity(d3);
        this.angle = d4;
    }

    public double distanceTraveled(long l) {
        long l2 = l - this.startTime;
        return (double)l2 * this.velocity;
    }

    public Point2D position(long l) {
        double d = this.distanceTraveled(l);
        double d2 = this.startX + d * Rutils.sin(this.angle);
        double d3 = this.startY + d * Rutils.cos(this.angle);
        return new Point2D.Double(d2, d3);
    }

    public double distanceTraveled(double d) {
        double d2 = d - (double)this.startTime;
        return d2 * this.velocity;
    }

    public Point2D position(double d) {
        double d2 = this.distanceTraveled(d);
        double d3 = this.startX + d2 * Rutils.sin(this.angle);
        double d4 = this.startY + d2 * Rutils.cos(this.angle);
        return new Point2D.Double(d3, d4);
    }

    public boolean hit(long l, double d, double d2) {
        Point2D point2D = this.position(l);
        if (point2D.distance(d, d2) > 50.0) {
            return false;
        }
        double d3 = 0.0;
        while (d3 <= 1.0) {
            point2D = this.position((double)l - d3);
            if (point2D.distance(d, d2) < 30.0) {
                return true;
            }
            d3 += 0.1;
        }
        return false;
    }

    public boolean missed(long l, double d, double d2) {
        double d3 = Point2D.Double.distance(this.startX, this.startY, d, d2);
        return this.distanceTraveled(l) > d3 + 36.0;
    }

    public int getID() {
        return this.ID;
    }
}

