/*
 * Decompiled with CFR 0.152.
 */
package co.edu.usb.rc;

import java.awt.geom.Point2D;

public class Trigonometry {
    public static double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }

    public static double getBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        return Math.atan2(xo, yo);
    }

    public static double turnRightAngle(double x1, double y1, double x2, double y2, double headingAngle) {
        double absDeg = Trigonometry.absoluteBearing(x1, y1, x2, y2);
        return Trigonometry.normalRelativeAngle(absDeg - headingAngle);
    }

    public static double getX(double x1, double angle, double distance) {
        double x = x1 + Math.sin(Math.toRadians(angle)) * distance;
        return x;
    }

    public static double getY(double y1, double angle, double distance) {
        double y = y1 + Math.cos(Math.toRadians(angle)) * distance;
        return y;
    }

    public static double getY(double y1, double heading, double bearing, double distance) {
        double absBearingDeg = heading + bearing;
        if (absBearingDeg < 0.0) {
            absBearingDeg += 360.0;
        }
        return Trigonometry.getY(y1, absBearingDeg, distance);
    }

    public static double getX(double x1, double heading, double bearing, double distance) {
        double absBearingDeg = heading + bearing;
        if (absBearingDeg < 0.0) {
            absBearingDeg += 360.0;
        }
        return Trigonometry.getX(x1, absBearingDeg, distance);
    }

    public static double inverseBearing(double angle) {
        if (angle < 0.0) {
            return angle + 180.0;
        }
        return angle - 180.0;
    }
}

