/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.robot;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RedDwarf
extends AdvancedRobot {
    static int ahead;
    static int radar;
    double targetScore;
    static String targetName;

    public void onScannedRobot(ScannedRobotEvent event) {
        if (event.getDistance() < this.targetScore || event.getName().equals(targetName)) {
            targetName = event.getName();
            this.targetScore = event.getDistance();
            radar = -radar;
            double targetBearing = Utils.normalAbsoluteAngleDegrees((double)(this.getHeading() + event.getBearing()));
            this.setTurnGunRight(Utils.normalRelativeAngleDegrees((double)(Utils.normalAbsoluteAngleDegrees((double)(targetBearing + 5.0 * event.getVelocity() * Math.sin(Math.toRadians(Utils.normalRelativeAngleDegrees((double)(event.getHeading() - targetBearing)))))) - this.getGunHeading())));
            this.setFire(event.getEnergy());
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (event.getName().equals(targetName)) {
            this.targetScore = 9999.0;
        }
    }

    public void run() {
        radar = 9999;
        ahead = 9999;
        this.targetScore = 9999;
        this.setAdjustGunForRobotTurn(true);
        this.setAllColors(Color.RED);
        while (true) {
            this.setAhead(ahead);
            this.setTurnLeft(10.0);
            if (this.getVelocity() == 0.0) {
                ahead = -ahead;
            }
            this.setTurnRadarRight(radar);
            this.execute();
        }
    }
}

